/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.utils;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import live.hms.video.events.AgentType;
import live.hms.video.events.AnalyticsEvent;
import live.hms.video.sdk.SignatureChecker;
import live.hms.video.sdk.models.FrameworkInfo;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u000e\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0018\u0010\u001f\u001a\n  *\u0004\u0018\u00010\b0\b2\u0006\u0010!\u001a\u00020\bH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\r\u0010\u000bR\u001b\u0010\u0010\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u000f\u001a\u0004\b\u0011\u0010\u000bR\u001b\u0010\u0013\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u000f\u001a\u0004\b\u0014\u0010\u000bR\u001b\u0010\u0016\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u000f\u001a\u0004\b\u0017\u0010\u000b\u00a8\u0006\""}, d2={"Llive/hms/video/utils/HMSAgentOs;", "", "frameworkInfo", "Llive/hms/video/sdk/models/FrameworkInfo;", "signatureChecker", "Llive/hms/video/sdk/SignatureChecker;", "(Llive/hms/video/sdk/models/FrameworkInfo;Llive/hms/video/sdk/SignatureChecker;)V", "TAG", "", "USER_AGENT_V2_NAME", "getUSER_AGENT_V2_NAME", "()Ljava/lang/String;", "userAgent", "getUserAgent", "userAgent$delegate", "Lkotlin/Lazy;", "userAgentUrlEncoded", "getUserAgentUrlEncoded", "userAgentUrlEncoded$delegate", "userAgentV2", "getUserAgentV2", "userAgentV2$delegate", "userAgentV2Encoded", "getUserAgentV2Encoded", "userAgentV2Encoded$delegate", "getDeviceId", "context", "Landroid/content/Context;", "getUniqueEventId", "event", "Llive/hms/video/events/AnalyticsEvent;", "getUrlEncodedAgent", "kotlin.jvm.PlatformType", "agent", "lib_release"})
public final class HMSAgentOs {
    @NotNull
    private final FrameworkInfo frameworkInfo;
    @NotNull
    private final String TAG;
    @NotNull
    private final String USER_AGENT_V2_NAME;
    @NotNull
    private final Lazy userAgentUrlEncoded$delegate;
    @NotNull
    private final Lazy userAgent$delegate;
    @NotNull
    private final Lazy userAgentV2$delegate;
    @NotNull
    private final Lazy userAgentV2Encoded$delegate;

    public HMSAgentOs(@NotNull FrameworkInfo frameworkInfo, @NotNull SignatureChecker signatureChecker) {
        Intrinsics.checkNotNullParameter((Object)frameworkInfo, (String)"frameworkInfo");
        Intrinsics.checkNotNullParameter((Object)signatureChecker, (String)"signatureChecker");
        this.frameworkInfo = frameworkInfo;
        this.TAG = "HMSAgentOs";
        this.USER_AGENT_V2_NAME = "user_agent_v2";
        this.userAgentUrlEncoded$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ HMSAgentOs this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return this.this$0.getUSER_AGENT_V2_NAME() + '=' + HMSAgentOs.access$getUserAgentV2Encoded(this.this$0);
            }
        }));
        this.userAgent$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ HMSAgentOs this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return HMSAgentOs.access$getUserAgentV2(this.this$0);
            }
        }));
        this.userAgentV2$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(signatureChecker, this){
            final /* synthetic */ SignatureChecker $signatureChecker;
            final /* synthetic */ HMSAgentOs this$0;
            {
                this.$signatureChecker = $signatureChecker;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                int osVersion = Build.VERSION.SDK_INT;
                String sdkVersion = "2.8.1";
                String string = Build.MODEL;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MODEL");
                String buildModel = StringsKt.replace$default((String)string, (String)" ", (String)"_", (boolean)false, (int)4, null);
                String env = this.$signatureChecker.isReleaseSigned() ? "prod" : "debug";
                return "os:android,os_version:" + osVersion + ",sdk:android,sdk_version:" + sdkVersion + ",device_model:" + buildModel + ",env:" + env + ",is_prebuilt:" + HMSAgentOs.access$getFrameworkInfo$p(this.this$0).isPrebuilt() + (HMSAgentOs.access$getFrameworkInfo$p(this.this$0).getFramework() != AgentType.ANDROID_NATIVE ? ",framework:" + HMSAgentOs.access$getFrameworkInfo$p(this.this$0).getFramework().getServerName() + ",framework_version:" + HMSAgentOs.access$getFrameworkInfo$p(this.this$0).getFrameworkVersion() + ",framework_sdk_version:" + HMSAgentOs.access$getFrameworkInfo$p(this.this$0).getFrameworkSdkVersion() : "");
            }
        }));
        this.userAgentV2Encoded$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ HMSAgentOs this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final String invoke() {
                return HMSAgentOs.access$getUrlEncodedAgent(this.this$0, HMSAgentOs.access$getUserAgentV2(this.this$0));
            }
        }));
    }

    @NotNull
    public final String getUSER_AGENT_V2_NAME() {
        return this.USER_AGENT_V2_NAME;
    }

    @NotNull
    public final String getUniqueEventId(@NotNull AnalyticsEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        int n = (event.getTimestamp() + event.getName()).hashCode();
        return String.valueOf(Math.abs(n));
    }

    @NotNull
    public final String getUserAgentUrlEncoded() {
        Lazy lazy = this.userAgentUrlEncoded$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String getUserAgent() {
        Lazy lazy = this.userAgent$delegate;
        return (String)lazy.getValue();
    }

    private final String getUserAgentV2() {
        Lazy lazy = this.userAgentV2$delegate;
        return (String)lazy.getValue();
    }

    private final String getUserAgentV2Encoded() {
        Lazy lazy = this.userAgentV2Encoded$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-userAgentV2Encoded>(...)");
        return (String)object;
    }

    private final String getUrlEncodedAgent(String agent) {
        String string;
        try {
            string = URLEncoder.encode(agent, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            string = StringsKt.replace$default((String)agent, (String)" ", (String)"_", (boolean)false, (int)4, null);
        }
        return string;
    }

    @SuppressLint(value={"HardwareIds"})
    @NotNull
    public final String getDeviceId(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id").toString();
    }

    public static final /* synthetic */ String access$getUserAgentV2Encoded(HMSAgentOs $this) {
        return $this.getUserAgentV2Encoded();
    }

    public static final /* synthetic */ String access$getUserAgentV2(HMSAgentOs $this) {
        return $this.getUserAgentV2();
    }

    public static final /* synthetic */ FrameworkInfo access$getFrameworkInfo$p(HMSAgentOs $this) {
        return $this.frameworkInfo;
    }

    public static final /* synthetic */ String access$getUrlEncodedAgent(HMSAgentOs $this, String agent) {
        return $this.getUrlEncodedAgent(agent);
    }
}

