/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.sdk;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.media.settings.HMSSimulcastLayer;
import live.hms.video.media.tracks.HMSRemoteVideoTrack;
import live.hms.video.media.tracks.HMSTrack;
import live.hms.video.sdk.SDKStore;
import live.hms.video.sdk.managers.IManager;
import live.hms.video.sdk.models.HMSNotifications;
import live.hms.video.sdk.models.HMSPeer;
import live.hms.video.sdk.models.SDKUpdate;
import live.hms.video.sdk.models.TrackForLayerUpdate;
import live.hms.video.sdk.models.enums.HMSTrackUpdate;
import live.hms.video.utils.HMSLogger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u0002H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Llive/hms/video/sdk/TrackLayerUpdateManager;", "Llive/hms/video/sdk/managers/IManager;", "Llive/hms/video/sdk/models/HMSNotifications$OnTrackLayerUpdate;", "store", "Llive/hms/video/sdk/SDKStore;", "(Llive/hms/video/sdk/SDKStore;)V", "TAG", "", "getStore", "()Llive/hms/video/sdk/SDKStore;", "manage", "", "Llive/hms/video/sdk/models/SDKUpdate;", "params", "lib_release"})
public final class TrackLayerUpdateManager
implements IManager<HMSNotifications.OnTrackLayerUpdate> {
    @NotNull
    private final SDKStore store;
    @NotNull
    private final String TAG;

    public TrackLayerUpdateManager(@NotNull SDKStore store) {
        Intrinsics.checkNotNullParameter((Object)store, (String)"store");
        this.store = store;
        this.TAG = "TrackLayerUpdateManager";
    }

    @Override
    @NotNull
    public SDKStore getStore() {
        return this.store;
    }

    @Override
    @NotNull
    public List<SDKUpdate> manage(@NotNull HMSNotifications.OnTrackLayerUpdate params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        List updates2 = new ArrayList();
        HMSLogger.INSTANCE.v(this.TAG, Intrinsics.stringPlus((String)"OnTrackLayerUpdate params: ", (Object)params));
        Map<String, TrackForLayerUpdate> map = params.getTracks();
        if (map != null) {
            Map<String, TrackForLayerUpdate> $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, TrackForLayerUpdate>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                SDKUpdate.Track sdkUpdate;
                SDKUpdate.Track track;
                Object object;
                Map.Entry<String, TrackForLayerUpdate> element$iv;
                Map.Entry<String, TrackForLayerUpdate> $dstr$trackId$update = element$iv = iterator.next();
                boolean bl = false;
                Map.Entry<String, TrackForLayerUpdate> entry = $dstr$trackId$update;
                String trackId = entry.getKey();
                Object object2 = $dstr$trackId$update;
                TrackForLayerUpdate update2 = object2.getValue();
                object2 = this.getStore().getNativeTrackById(trackId);
                if (object2 == null) continue;
                Object track2 = object = object2;
                boolean bl2 = false;
                if (!(track2 instanceof HMSRemoteVideoTrack)) continue;
                boolean wasPreviouslyDegraded = ((HMSRemoteVideoTrack)track2).isDegraded();
                boolean isDegradedNow = update2.getSubscriberDegraded() && update2.getCurrentSimulcastLayer() == HMSSimulcastLayer.NONE;
                ((HMSRemoteVideoTrack)track2).setCurrentLayer$lib_release(update2.getCurrentSimulcastLayer());
                ((HMSRemoteVideoTrack)track2).setDegraded$lib_release(isDegradedNow);
                if (isDegradedNow == wasPreviouslyDegraded) continue;
                HMSPeer hMSPeer = this.getStore().getPeerByTrackId(((HMSTrack)track2).getTrackId());
                if (hMSPeer == null) {
                    track = null;
                } else {
                    HMSPeer hMSPeer2;
                    HMSPeer peer = hMSPeer2 = hMSPeer;
                    boolean bl3 = false;
                    HMSTrackUpdate type = isDegradedNow ? HMSTrackUpdate.TRACK_DEGRADED : HMSTrackUpdate.TRACK_RESTORED;
                    track = new SDKUpdate.Track(type, (HMSTrack)track2, peer);
                }
                if ((sdkUpdate = track) == null) continue;
                updates2.add(sdkUpdate);
            }
        }
        HMSLogger.INSTANCE.v(this.TAG, Intrinsics.stringPlus((String)"Updates: ", (Object)updates2));
        return updates2;
    }
}

