/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.sdk.managers;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.sdk.SDKStore;
import live.hms.video.sdk.managers.IManager;
import live.hms.video.sdk.models.HMSBrowserRecordingState;
import live.hms.video.sdk.models.HMSNotifications;
import live.hms.video.sdk.models.HMSRoom;
import live.hms.video.sdk.models.HMSServerRecordingState;
import live.hms.video.sdk.models.RecordingType;
import live.hms.video.sdk.models.SDKUpdate;
import live.hms.video.sdk.models.enums.HMSRoomUpdate;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J7\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Llive/hms/video/sdk/managers/RecordingUpdateManager;", "Llive/hms/video/sdk/managers/IManager;", "Llive/hms/video/sdk/models/HMSNotifications$RecordingStateChangeNotification;", "store", "Llive/hms/video/sdk/SDKStore;", "(Llive/hms/video/sdk/SDKStore;)V", "getStore", "()Llive/hms/video/sdk/SDKStore;", "manage", "", "Llive/hms/video/sdk/models/SDKUpdate;", "params", "setRecordingStateOnRoom", "type", "Llive/hms/video/sdk/models/RecordingType;", "started", "", "timeOccurred", "", "error", "Llive/hms/video/sdk/models/HMSNotifications$ServerError;", "(Llive/hms/video/sdk/models/RecordingType;ZLjava/lang/Long;Llive/hms/video/sdk/models/HMSNotifications$ServerError;)Ljava/util/List;", "lib_release"})
public final class RecordingUpdateManager
implements IManager<HMSNotifications.RecordingStateChangeNotification> {
    @NotNull
    private final SDKStore store;

    public RecordingUpdateManager(@NotNull SDKStore store) {
        Intrinsics.checkNotNullParameter((Object)store, (String)"store");
        this.store = store;
    }

    @Override
    @NotNull
    public SDKStore getStore() {
        return this.store;
    }

    @Override
    @NotNull
    public List<SDKUpdate> manage(@NotNull HMSNotifications.RecordingStateChangeNotification params) {
        List<SDKUpdate> list;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        HMSNotifications.RecordingStateChangeNotification recordingStateChangeNotification = params;
        if (recordingStateChangeNotification instanceof HMSNotifications.RecordingStateChangeNotification.Start) {
            list = this.setRecordingStateOnRoom(((HMSNotifications.RecordingStateChangeNotification.Start)params).getType(), true, ((HMSNotifications.RecordingStateChangeNotification.Start)params).getStartedAt(), ((HMSNotifications.RecordingStateChangeNotification.Start)params).getError());
        } else if (recordingStateChangeNotification instanceof HMSNotifications.RecordingStateChangeNotification.Stop) {
            list = this.setRecordingStateOnRoom(((HMSNotifications.RecordingStateChangeNotification.Stop)params).getType(), false, ((HMSNotifications.RecordingStateChangeNotification.Stop)params).getStoppedAt(), ((HMSNotifications.RecordingStateChangeNotification.Stop)params).getError());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    private final List<SDKUpdate> setRecordingStateOnRoom(RecordingType type, boolean started, Long timeOccurred, HMSNotifications.ServerError error) {
        SDKUpdate sDKUpdate;
        HMSRoom room = this.getStore().get_room();
        if (room == null) {
            return CollectionsKt.emptyList();
        }
        RecordingType recordingType = type;
        int n = WhenMappings.$EnumSwitchMapping$0[recordingType.ordinal()];
        switch (n) {
            case 1: {
                room.setServerRecordingState$lib_release(new HMSServerRecordingState(started, null, timeOccurred));
                sDKUpdate = new SDKUpdate.Room(HMSRoomUpdate.SERVER_RECORDING_STATE_UPDATED);
                break;
            }
            case 2: {
                Object object;
                HMSBrowserRecordingState hMSBrowserRecordingState;
                Long startedAt;
                Long l = started ? timeOccurred : (startedAt = (hMSBrowserRecordingState = room.getBrowserRecordingState()) == null ? null : hMSBrowserRecordingState.getStartedAt());
                Long stoppedAt = !started ? timeOccurred : ((object = room.getBrowserRecordingState()) == null ? null : ((HMSBrowserRecordingState)object).getStoppedAt());
                object = error;
                room.setBrowserRecordingState$lib_release(new HMSBrowserRecordingState(started, object == null ? null : ((HMSNotifications.ServerError)object).toHmsException(), startedAt, stoppedAt));
                sDKUpdate = new SDKUpdate.Room(HMSRoomUpdate.BROWSER_RECORDING_STATE_UPDATED);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        SDKUpdate update2 = sDKUpdate;
        return CollectionsKt.listOf((Object)update2);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RecordingType.values().length];
            nArray[RecordingType.SFU.ordinal()] = 1;
            nArray[RecordingType.BROWSER.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

