/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.media.capturers.camera;

import android.content.Context;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.os.Build;
import android.util.Range;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.SafeContinuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.media.capturers.camera.utils.ImageCaptureModel;
import live.hms.video.utils.HMSUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0014\u0010\u0004\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0014\u0010\b\u001a\u00020\t*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0016\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\u00012\u0006\u0010\n\u001a\u00020\u0005H\u0000\u001a\u0014\u0010\u000b\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0014\u0010\f\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0014\u0010\u0010\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0014\u0010\u0012\u001a\u00020\u0003*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a%\u0010\u0013\u001a\u00020\u0014*\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0019\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001a"}, d2={"computeExifOrientation", "", "mirrored", "", "computeRelativeRotation", "Landroid/content/Context;", "cameraId", "", "getCameraCharacteristics", "Landroid/hardware/camera2/CameraCharacteristics;", "context", "getExposureMaxMeteringRegionsSupported", "getFocusMaxMeteringRegionsSupported", "getLensDistanceRange", "Landroid/util/Range;", "", "getWhiteBalanceMeteringRegionsSupported", "getZoomRatioRange", "isFlashAvailable", "saveResult", "", "result", "Llive/hms/video/media/capturers/camera/utils/ImageCaptureModel;", "filePathToSave", "Ljava/io/File;", "(Landroid/content/Context;Llive/hms/video/media/capturers/camera/utils/ImageCaptureModel;Ljava/io/File;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib_release"})
public final class CameraExtKt {
    public static final boolean isFlashAvailable(@NotNull Context $this$isFlashAvailable, @NotNull String cameraId) {
        Intrinsics.checkNotNullParameter((Object)$this$isFlashAvailable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId, (String)"cameraId");
        Boolean bl = (Boolean)CameraExtKt.getCameraCharacteristics($this$isFlashAvailable, cameraId).get(CameraCharacteristics.FLASH_INFO_AVAILABLE);
        return bl == null ? false : bl;
    }

    public static final int getWhiteBalanceMeteringRegionsSupported(@NotNull Context $this$getWhiteBalanceMeteringRegionsSupported, @NotNull String cameraId) {
        Intrinsics.checkNotNullParameter((Object)$this$getWhiteBalanceMeteringRegionsSupported, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId, (String)"cameraId");
        Integer n = (Integer)CameraExtKt.getCameraCharacteristics($this$getWhiteBalanceMeteringRegionsSupported, cameraId).get(CameraCharacteristics.CONTROL_MAX_REGIONS_AWB);
        return n == null ? 0 : n;
    }

    public static final int getExposureMaxMeteringRegionsSupported(@NotNull Context $this$getExposureMaxMeteringRegionsSupported, @NotNull String cameraId) {
        Intrinsics.checkNotNullParameter((Object)$this$getExposureMaxMeteringRegionsSupported, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId, (String)"cameraId");
        Integer n = (Integer)CameraExtKt.getCameraCharacteristics($this$getExposureMaxMeteringRegionsSupported, cameraId).get(CameraCharacteristics.CONTROL_MAX_REGIONS_AE);
        return n == null ? 0 : n;
    }

    @NotNull
    public static final Range<Float> getZoomRatioRange(@NotNull Context $this$getZoomRatioRange, @NotNull String cameraId) {
        Range range;
        Intrinsics.checkNotNullParameter((Object)$this$getZoomRatioRange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId, (String)"cameraId");
        if (Build.VERSION.SDK_INT >= 30) {
            Range range2;
            Range range3 = (Range)CameraExtKt.getCameraCharacteristics($this$getZoomRatioRange, cameraId).get(CameraCharacteristics.CONTROL_ZOOM_RATIO_RANGE);
            range = range2 = range3 == null ? new Range((Comparable)Float.valueOf(1.0f), (Comparable)Float.valueOf(1.0f)) : range3;
        } else {
            Range range4;
            Float f = (Float)CameraExtKt.getCameraCharacteristics($this$getZoomRatioRange, cameraId).get(CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM);
            if (f == null) {
                range4 = null;
            } else {
                Float f2;
                Float maxZoom = f2 = f;
                boolean bl = false;
                range4 = new Range((Comparable)Float.valueOf(1.0f), (Comparable)maxZoom);
            }
            Range range5 = range4;
            range = range5 == null ? new Range((Comparable)Float.valueOf(1.0f), (Comparable)Float.valueOf(1.0f)) : range5;
        }
        return range;
    }

    public static final int getFocusMaxMeteringRegionsSupported(@NotNull Context $this$getFocusMaxMeteringRegionsSupported, @NotNull String cameraId) {
        Intrinsics.checkNotNullParameter((Object)$this$getFocusMaxMeteringRegionsSupported, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId, (String)"cameraId");
        Integer n = (Integer)CameraExtKt.getCameraCharacteristics($this$getFocusMaxMeteringRegionsSupported, cameraId).get(CameraCharacteristics.CONTROL_MAX_REGIONS_AF);
        return n == null ? 0 : n;
    }

    public static final int computeRelativeRotation(@NotNull Context $this$computeRelativeRotation, @NotNull String cameraId) {
        Intrinsics.checkNotNullParameter((Object)$this$computeRelativeRotation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId, (String)"cameraId");
        CameraCharacteristics characteristics = CameraExtKt.getCameraCharacteristics($this$computeRelativeRotation, cameraId);
        Integer n = (Integer)characteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
        Integer n2 = n == null ? Integer.valueOf(0) : n;
        int sensorOrientationDegrees = ((Number)n2).intValue();
        n = (Integer)characteristics.get(CameraCharacteristics.LENS_FACING);
        boolean invertDeviceOrientationReadings = n == null ? false : n == 1;
        int rotation = invertDeviceOrientationReadings ? 360 - HMSUtils.INSTANCE.getOrientation($this$computeRelativeRotation) : HMSUtils.INSTANCE.getOrientation($this$computeRelativeRotation);
        return (sensorOrientationDegrees + rotation) % 360;
    }

    @NotNull
    public static final CameraCharacteristics getCameraCharacteristics(@NotNull Context $this$getCameraCharacteristics, @NotNull String cameraId) {
        Intrinsics.checkNotNullParameter((Object)$this$getCameraCharacteristics, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId, (String)"cameraId");
        Object object = $this$getCameraCharacteristics.getSystemService("camera");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.hardware.camera2.CameraManager");
        }
        CameraManager cameraManager = (CameraManager)object;
        object = cameraManager.getCameraCharacteristics(cameraId);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"cameraManager.getCameraCharacteristics(cameraId)");
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Nullable
    public static final Object saveResult(@NotNull Context $this$saveResult, @NotNull ImageCaptureModel result2, @NotNull File filePathToSave, @NotNull Continuation<? super Unit> $completion) {
        Continuation<? super Unit> continuation = $completion;
        boolean bl = false;
        SafeContinuation safeContinuation = new SafeContinuation(IntrinsicsKt.intercepted(continuation));
        Continuation cont = (Continuation)safeContinuation;
        boolean bl2 = false;
        int n = result2.getFormat();
        switch (n) {
            case 256: 
            case 1768253795: {
                ByteBuffer buffer = result2.getImage().getPlanes()[0].getBuffer();
                byte[] byArray = new byte[buffer.remaining()];
                Object $this$saveResult_u24lambda_u2d4_u24lambda_u2d1 = byArray;
                boolean bl3 = false;
                buffer.get((byte[])$this$saveResult_u24lambda_u2d4_u24lambda_u2d1);
                byte[] bytes = byArray;
                Object output = null;
                Object $this$saveResult_u24lambda_u2d4_u24lambda_u2d2 = $this$saveResult_u24lambda_u2d4_u24lambda_u2d1 = (Object)new FileOutputStream(filePathToSave);
                boolean $i$a$-apply-CameraExtKt$saveResult$2$2333333332 = false;
                ((FileOutputStream)$this$saveResult_u24lambda_u2d4_u24lambda_u2d2).write(bytes);
                Unit unit = Unit.INSTANCE;
                output = $this$saveResult_u24lambda_u2d4_u24lambda_u2d1;
                $this$saveResult_u24lambda_u2d4_u24lambda_u2d1 = cont;
                $this$saveResult_u24lambda_u2d4_u24lambda_u2d2 = Unit.INSTANCE;
                Object $i$a$-apply-CameraExtKt$saveResult$2$2333333332 = Result.Companion;
                $this$saveResult_u24lambda_u2d4_u24lambda_u2d1.resumeWith(Result.constructor-impl((Object)$this$saveResult_u24lambda_u2d4_u24lambda_u2d2));
                result2.close();
                try {
                    $this$saveResult_u24lambda_u2d4_u24lambda_u2d1 = Result.Companion;
                    boolean $i$a$-runCatching-CameraExtKt$saveResult$2$3333333332 = false;
                    $i$a$-apply-CameraExtKt$saveResult$2$2333333332 = output;
                    ((FileOutputStream)$i$a$-apply-CameraExtKt$saveResult$2$2333333332).close();
                    Unit $i$a$-runCatching-CameraExtKt$saveResult$2$3333333332 = Unit.INSTANCE;
                    $this$saveResult_u24lambda_u2d4_u24lambda_u2d1 = Result.constructor-impl((Object)$i$a$-runCatching-CameraExtKt$saveResult$2$3333333332);
                }
                catch (Throwable $i$a$-runCatching-CameraExtKt$saveResult$2$3333333332) {
                    $i$a$-apply-CameraExtKt$saveResult$2$2333333332 = Result.Companion;
                    $this$saveResult_u24lambda_u2d4_u24lambda_u2d1 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-CameraExtKt$saveResult$2$3333333332));
                }
                break;
                catch (IOException exc) {
                    try {
                        Continuation $i$a$-runCatching-CameraExtKt$saveResult$2$3333333332 = cont;
                        $i$a$-apply-CameraExtKt$saveResult$2$2333333332 = Result.Companion;
                        $i$a$-runCatching-CameraExtKt$saveResult$2$3333333332.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)exc)));
                        result2.close();
                    }
                    catch (Throwable throwable) {
                        result2.close();
                        try {
                            Unit unit2;
                            Object object = Result.Companion;
                            boolean bl4 = false;
                            FileOutputStream fileOutputStream = output;
                            if (fileOutputStream == null) {
                                unit2 = null;
                            } else {
                                fileOutputStream.close();
                                unit2 = Unit.INSTANCE;
                            }
                            Unit unit3 = unit2;
                            object = Result.constructor-impl((Object)unit3);
                        }
                        catch (Throwable throwable2) {
                            Result.Companion companion = Result.Companion;
                            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                        }
                        throw throwable;
                    }
                    try {
                        Unit unit4;
                        Object object = Result.Companion;
                        boolean bl5 = false;
                        $i$a$-apply-CameraExtKt$saveResult$2$2333333332 = output;
                        if ($i$a$-apply-CameraExtKt$saveResult$2$2333333332 == null) {
                            unit4 = null;
                        } else {
                            ((FileOutputStream)$i$a$-apply-CameraExtKt$saveResult$2$2333333332).close();
                            unit4 = Unit.INSTANCE;
                        }
                        Unit unit5 = unit4;
                        object = Result.constructor-impl((Object)unit5);
                    }
                    catch (Throwable throwable) {
                        $i$a$-apply-CameraExtKt$saveResult$2$2333333332 = Result.Companion;
                        Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                    break;
                }
            }
            default: {
                RuntimeException exc = new RuntimeException(Intrinsics.stringPlus((String)"Unknown image format: ", (Object)Boxing.boxInt((int)result2.getImage().getFormat())));
                Continuation continuation2 = cont;
                Result.Companion companion = Result.Companion;
                continuation2.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)exc)));
            }
        }
        Object object = safeContinuation.getOrThrow();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public static final CameraCharacteristics getCameraCharacteristics(int $this$getCameraCharacteristics, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("camera");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.hardware.camera2.CameraManager");
        }
        CameraManager manager = (CameraManager)object;
        try {
            String[] stringArray = manager.getCameraIdList();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"manager.cameraIdList");
            String[] cameraIdList = stringArray;
            if ($this$getCameraCharacteristics < cameraIdList.length) {
                return manager.getCameraCharacteristics(cameraIdList[$this$getCameraCharacteristics]);
            }
            object = null;
        }
        catch (Exception ex) {
            object = null;
        }
        return object;
    }

    @NotNull
    public static final Range<Float> getLensDistanceRange(@NotNull Context $this$getLensDistanceRange, @NotNull String cameraId) {
        Intrinsics.checkNotNullParameter((Object)$this$getLensDistanceRange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId, (String)"cameraId");
        Float f = (Float)CameraExtKt.getCameraCharacteristics($this$getLensDistanceRange, cameraId).get(CameraCharacteristics.LENS_INFO_MINIMUM_FOCUS_DISTANCE);
        return new Range((Comparable)Float.valueOf(0.0f), (Comparable)(f == null ? Float.valueOf(0.0f) : f));
    }

    public static final int computeExifOrientation(int $this$computeExifOrientation, boolean mirrored) {
        return $this$computeExifOrientation == 0 && !mirrored ? 1 : ($this$computeExifOrientation == 0 && mirrored ? 2 : ($this$computeExifOrientation == 180 && !mirrored ? 3 : ($this$computeExifOrientation == 180 && mirrored ? 4 : ($this$computeExifOrientation == 270 && mirrored ? 7 : ($this$computeExifOrientation == 90 && !mirrored ? 6 : ($this$computeExifOrientation == 90 && mirrored ? 5 : ($this$computeExifOrientation == 270 && mirrored ? 8 : ($this$computeExifOrientation == 270 && !mirrored ? 7 : 0))))))));
    }
}

