/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.sdk.managers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.media.settings.HMSLayer;
import live.hms.video.media.settings.HMSSimulcastLayerDefinition;
import live.hms.video.media.settings.HMSVideoResolution;
import live.hms.video.media.tracks.HMSRemoteAudioTrack;
import live.hms.video.media.tracks.HMSRemoteVideoTrack;
import live.hms.video.media.tracks.HMSTrack;
import live.hms.video.media.tracks.HMSTrackType;
import live.hms.video.sdk.SDKStore;
import live.hms.video.sdk.managers.IManager;
import live.hms.video.sdk.models.HMSNotifications;
import live.hms.video.sdk.models.HMSPeer;
import live.hms.video.sdk.models.HMSRemotePeer;
import live.hms.video.sdk.models.SDKUpdate;
import live.hms.video.sdk.models.enums.HMSTrackUpdate;
import live.hms.video.sdk.models.role.HMSRole;
import live.hms.video.sdk.models.role.LayerParams;
import live.hms.video.sdk.models.role.PublishParams;
import live.hms.video.sdk.models.role.Simulcast;
import live.hms.video.sdk.models.role.VideoParams;
import live.hms.video.sdk.models.role.VideoSimulcastLayersParams;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J!\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018J\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\f\u001a\u00020\rJ(\u0010\u001a\u001a\u00020\t*\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001e"}, d2={"Llive/hms/video/sdk/managers/OnTrackAddManager;", "Llive/hms/video/sdk/managers/IManager;", "Llive/hms/video/sdk/models/HMSNotifications$TrackMetadata;", "store", "Llive/hms/video/sdk/SDKStore;", "(Llive/hms/video/sdk/SDKStore;)V", "getStore", "()Llive/hms/video/sdk/SDKStore;", "applyPeerToTrack", "", "peer", "Llive/hms/video/sdk/models/HMSRemotePeer;", "track", "Llive/hms/video/media/tracks/HMSTrack;", "manage", "", "Llive/hms/video/sdk/models/SDKUpdate;", "params", "manageMetadata", "", "data", "Llive/hms/video/sdk/models/HMSNotifications$Track;", "peerId", "", "(Llive/hms/video/sdk/models/HMSNotifications$Track;Ljava/lang/String;)[Llive/hms/video/sdk/models/SDKUpdate;", "manageNativeTrack", "addSimulcastLayerDefinitionFromPeer", "rolesMap", "", "Llive/hms/video/sdk/models/role/HMSRole;", "lib_release"})
public final class OnTrackAddManager
implements IManager<HMSNotifications.TrackMetadata> {
    @NotNull
    private final SDKStore store;

    public OnTrackAddManager(@NotNull SDKStore store) {
        Intrinsics.checkNotNullParameter((Object)store, (String)"store");
        this.store = store;
    }

    @Override
    @NotNull
    public SDKStore getStore() {
        return this.store;
    }

    @Override
    @NotNull
    public List<SDKUpdate> manage(@NotNull HMSNotifications.TrackMetadata params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        ArrayList updates2 = new ArrayList();
        for (HMSNotifications.Track data : params.getTracks()) {
            CollectionsKt.addAll((Collection)updates2, (Object[])this.manageMetadata(data, params.getPeer().getPeerId()));
        }
        return updates2;
    }

    @NotNull
    public final SDKUpdate[] manageMetadata(@NotNull HMSNotifications.Track data, @NotNull String peerId) {
        Unit unit;
        Unit unit2;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)peerId, (String)"peerId");
        ArrayList<SDKUpdate.Track> updates2 = new ArrayList<SDKUpdate.Track>();
        Object object = this.getStore().getPeerById(peerId);
        if (object == null) {
            unit2 = null;
        } else {
            HMSPeer hMSPeer;
            HMSPeer peer = hMSPeer = object;
            boolean bl = false;
            HMSRemotePeer cfr_ignored_0 = (HMSRemotePeer)peer;
            HMSTrack hMSTrack = this.getStore().getTrackById(data.getTrackId());
            if (hMSTrack != null) {
                HMSTrack hMSTrack2;
                HMSTrack track = hMSTrack2 = hMSTrack;
                boolean bl2 = false;
                this.getStore().updateRTCTrack(data);
                this.applyPeerToTrack((HMSRemotePeer)peer, track);
                updates2.add(new SDKUpdate.Track(HMSTrackUpdate.TRACK_ADDED, track, peer));
            }
            this.getStore().add(data, peerId);
            unit2 = unit = Unit.INSTANCE;
        }
        if (unit == null) {
            object = this;
            OnTrackAddManager $this$manageMetadata_u24lambda_u2d2 = (OnTrackAddManager)object;
            boolean bl = false;
        }
        Collection $this$toTypedArray$iv = updates2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        SDKUpdate[] sDKUpdateArray = thisCollection$iv.toArray(new SDKUpdate[0]);
        if (sDKUpdateArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        return sDKUpdateArray;
    }

    @NotNull
    public final List<SDKUpdate> manageNativeTrack(@NotNull HMSTrack track) {
        HMSTrack remoteTrack2;
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)track, (String)"track");
        List updates2 = new ArrayList();
        this.getStore().add(track);
        Object object = this.getStore().getTrackDataById(track.getTrackId());
        if (object == null) {
            unit = null;
        } else {
            Object object2;
            SDKStore.TrackMetadataPair trackMetadataPair;
            SDKStore.TrackMetadataPair it = trackMetadataPair = object;
            boolean bl = false;
            this.getStore().updateRTCTrack(it.getTrackData());
            Object object3 = this.getStore().getPeerById(it.getPeerId());
            if (object3 == null) {
                object2 = null;
            } else {
                HMSPeer hMSPeer;
                HMSPeer peer = hMSPeer = object3;
                boolean bl2 = false;
                HMSRemotePeer cfr_ignored_0 = (HMSRemotePeer)peer;
                this.applyPeerToTrack((HMSRemotePeer)peer, track);
                object2 = updates2.add(new SDKUpdate.Track(HMSTrackUpdate.TRACK_ADDED, track, peer));
            }
            Unit unit2 = object2;
            if (unit2 == null) {
                object3 = this;
                OnTrackAddManager $this$manageNativeTrack_u24lambda_u2d5_u24lambda_u2d4 = (OnTrackAddManager)object3;
                boolean bl3 = false;
                unit = Unit.INSTANCE;
            } else {
                unit = unit2;
            }
        }
        Unit unit3 = unit;
        if (unit3 == null) {
            object = this;
            OnTrackAddManager $this$manageNativeTrack_u24lambda_u2d6 = (OnTrackAddManager)object;
            boolean bl = false;
        }
        if (this.getStore().getLocalTracksMute() && (remoteTrack2 = this.getStore().getTrackById(track.getTrackId())) instanceof HMSRemoteAudioTrack) {
            ((HMSRemoteAudioTrack)remoteTrack2).setVolume(0.0);
        }
        return updates2;
    }

    /*
     * WARNING - void declaration
     */
    private final void addSimulcastLayerDefinitionFromPeer(HMSTrack $this$addSimulcastLayerDefinitionFromPeer, HMSRemotePeer peer, Map<String, HMSRole> rolesMap) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object;
        Object object2;
        HMSRole hMSRole = rolesMap.get(peer.getHmsRole().getName());
        VideoSimulcastLayersParams simulcastRemoteParams = hMSRole == null ? null : ((object2 = hMSRole.getPublishParams()) == null ? null : ((object = ((PublishParams)object2).getSimulcast()) == null ? null : ((Simulcast)object).getVideo()));
        object2 = rolesMap.get(peer.getHmsRole().getName());
        VideoParams videoParams = object2 == null ? null : ((object = ((HMSRole)object2).getPublishParams()) == null ? null : ((PublishParams)object).getVideo());
        object = simulcastRemoteParams;
        Object object3 = object = (List)(object == null ? null : ((VideoSimulcastLayersParams)object).getLayers());
        object = (Iterable)(object3 == null ? CollectionsKt.emptyList() : object3);
        boolean $i$f$map = false;
        void var9_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void layer;
            int n;
            LayerParams layerParams = (LayerParams)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object object4 = videoParams;
            int n2 = object4 == null ? 0 : (n = ((VideoParams)object4).getWidth());
            object4 = layer.getScaleResolutionDownBy();
            int n3 = n2 / ((Number)(object4 == null ? Integer.valueOf(1) : object4)).intValue();
            object4 = videoParams;
            int n4 = object4 == null ? 0 : (n = ((VideoParams)object4).getHeight());
            object4 = layer.getScaleResolutionDownBy();
            HMSSimulcastLayerDefinition hMSSimulcastLayerDefinition = new HMSSimulcastLayerDefinition(new HMSVideoResolution(n3, n4 / ((Number)(object4 == null ? Integer.valueOf(1) : object4)).intValue()), OnTrackAddManager.addSimulcastLayerDefinitionFromPeer$ridToHMSLayerMapper((LayerParams)layer));
            collection.add(hMSSimulcastLayerDefinition);
        }
        List hmsSimulcastLayerDefinitions = (List)destination$iv$iv;
        Object object5 = object = $this$addSimulcastLayerDefinitionFromPeer instanceof HMSRemoteVideoTrack ? (HMSRemoteVideoTrack)$this$addSimulcastLayerDefinitionFromPeer : null;
        if (object != null) {
            ((HMSRemoteVideoTrack)object).setLayerDefinition$lib_release(hmsSimulcastLayerDefinitions);
        }
    }

    private final void applyPeerToTrack(HMSRemotePeer peer, HMSTrack track) {
        if (Intrinsics.areEqual((Object)track.getSource(), (Object)"regular")) {
            HMSTrackType hMSTrackType = track.getType();
            int n = WhenMappings.$EnumSwitchMapping$0[hMSTrackType.ordinal()];
            switch (n) {
                case 1: {
                    peer.setAudioTrack$lib_release((HMSRemoteAudioTrack)track);
                    break;
                }
                case 2: {
                    peer.setVideoTrack$lib_release((HMSRemoteVideoTrack)track);
                }
            }
        } else {
            peer.getAuxiliaryTracks().add(track);
        }
        this.addSimulcastLayerDefinitionFromPeer(track, peer, this.getStore().getRolesMap());
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final HMSLayer addSimulcastLayerDefinitionFromPeer$ridToHMSLayerMapper(LayerParams layerParams) {
        HMSLayer hMSLayer;
        String string = layerParams.getRid();
        if (string != null) {
            int n = -1;
            switch (string.hashCode()) {
                case 113: {
                    if (!string.equals("q")) break;
                    n = 1;
                    break;
                }
                case 102: {
                    if (!string.equals("f")) break;
                    n = 2;
                    break;
                }
                case 104: {
                    if (!string.equals("h")) break;
                    n = 3;
                    break;
                }
            }
            switch (n) {
                case 2: {
                    hMSLayer = HMSLayer.HIGH;
                    return hMSLayer;
                }
                case 3: {
                    hMSLayer = HMSLayer.MEDIUM;
                    return hMSLayer;
                }
                case 1: {
                    hMSLayer = HMSLayer.LOW;
                    return hMSLayer;
                }
            }
        }
        hMSLayer = HMSLayer.HIGH;
        return hMSLayer;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HMSTrackType.values().length];
            nArray[HMSTrackType.AUDIO.ordinal()] = 1;
            nArray[HMSTrackType.VIDEO.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

