/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.sdk;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.connection.degredation.Audio;
import live.hms.video.connection.degredation.ConnectionInfo;
import live.hms.video.connection.degredation.Peer;
import live.hms.video.connection.degredation.StatsBundle;
import live.hms.video.connection.degredation.Track;
import live.hms.video.connection.degredation.Video;
import live.hms.video.connection.degredation.WebrtcStats;
import live.hms.video.connection.stats.BitrateCalculator;
import live.hms.video.connection.stats.HMSLocalAudioStats;
import live.hms.video.connection.stats.HMSLocalVideoStats;
import live.hms.video.connection.stats.HMSRTCStats;
import live.hms.video.connection.stats.HMSRTCStatsReport;
import live.hms.video.connection.stats.HMSRemoteAudioStats;
import live.hms.video.connection.stats.HMSRemoteVideoStats;
import live.hms.video.connection.stats.HMSStatsObserver;
import live.hms.video.media.settings.HMSVideoResolution;
import live.hms.video.media.tracks.HMSTrack;
import live.hms.video.sdk.PublishConnection;
import live.hms.video.sdk.SubscribeConnection;
import live.hms.video.sdk.models.HMSLocalPeer;
import live.hms.video.sdk.models.HMSPeer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JR\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\f2\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u00100\f2\u000e\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Llive/hms/video/sdk/BundleToStatsObserver;", "", "()V", "bitrateCalculator", "Llive/hms/video/connection/stats/BitrateCalculator;", "convertBundleToStatsObserverEvents", "", "bundle", "Llive/hms/video/connection/degredation/StatsBundle;", "hmsStatsObserver", "Llive/hms/video/connection/stats/HMSStatsObserver;", "getTrackForId", "Lkotlin/Function1;", "", "Llive/hms/video/media/tracks/HMSTrack;", "getRemotePeerForTrackId", "Llive/hms/video/sdk/models/HMSPeer;", "getLocalPeer", "Lkotlin/Function0;", "Llive/hms/video/sdk/models/HMSLocalPeer;", "lib_release"})
public final class BundleToStatsObserver {
    @NotNull
    private final BitrateCalculator bitrateCalculator = new BitrateCalculator();

    public final void convertBundleToStatsObserverEvents(@NotNull StatsBundle bundle, @NotNull HMSStatsObserver hmsStatsObserver, @NotNull Function1<? super String, ? extends HMSTrack> getTrackForId, @NotNull Function1<? super String, ? extends HMSPeer> getRemotePeerForTrackId, @NotNull Function0<HMSLocalPeer> getLocalPeer) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        Intrinsics.checkNotNullParameter((Object)hmsStatsObserver, (String)"hmsStatsObserver");
        Intrinsics.checkNotNullParameter(getTrackForId, (String)"getTrackForId");
        Intrinsics.checkNotNullParameter(getRemotePeerForTrackId, (String)"getRemotePeerForTrackId");
        Intrinsics.checkNotNullParameter(getLocalPeer, (String)"getLocalPeer");
        PublishConnection audioPubConnection = new PublishConnection(0L, null, 0L, 7, null);
        PublishConnection videoPubConnection = new PublishConnection(0L, null, 0L, 7, null);
        SubscribeConnection audioSubConnection = new SubscribeConnection(0L, null, 0L, 7, null);
        SubscribeConnection videoSubConnection = new SubscribeConnection(0L, null, 0L, 7, null);
        double publishRoundTripTime = 0.0;
        double subscribeRoundTripTime = 0.0;
        Map<String, WebrtcStats> map2 = bundle.getAllStats();
        for (Map.Entry<String, WebrtcStats> item : map2.entrySet()) {
            WebrtcStats stat = item.getValue();
            if (!(stat instanceof Peer)) {
                Double bitrate5;
                Object audioStats;
                Object object;
                Object object2;
                if (stat instanceof Track.LocalTrack.LocalVideo) {
                    long l;
                    double bitrate2 = this.bitrateCalculator.getBitrateFromTrackUpdatePrev((Track)stat);
                    object2 = ((Track.LocalTrack.LocalVideo)stat).getBytesTransported();
                    long bytesSent = object2 == null ? 0L : (l = ((BigInteger)object2).longValue());
                    object2 = ((Track.LocalTrack.LocalVideo)stat).getFrameRate();
                    hmsStatsObserver.onLocalVideoStats(new HMSLocalVideoStats(((Track.LocalTrack.LocalVideo)stat).getRoundTripTime(), bytesSent, bitrate2, ((Track.LocalTrack.LocalVideo)stat).getResolution(), object2 == null ? null : Double.valueOf(((Number)object2).doubleValue()), ((Track.LocalTrack.LocalVideo)stat).getQualityLimitations()), (HMSTrack)getTrackForId.invoke((Object)item.getKey()), (HMSPeer)getLocalPeer.invoke());
                    videoPubConnection.getAvailableOutgoingBitrates().add(bitrate2);
                    object2 = videoPubConnection;
                    ((PublishConnection)object2).setBytesSent(((PublishConnection)object2).getBytesSent() + bytesSent);
                    object2 = videoPubConnection;
                    object = ((Track.LocalTrack.LocalVideo)stat).getPacketsSent();
                    ((PublishConnection)object2).setPacketsSent(((PublishConnection)object2).getPacketsSent() + (object == null ? 0L : (Long)object));
                } else if (stat instanceof Track.LocalTrack.LocalAudio) {
                    long l;
                    double bitrate3 = this.bitrateCalculator.getBitrateFromTrackUpdatePrev((Track)stat);
                    object2 = ((Track.LocalTrack.LocalAudio)stat).getBytesTransported();
                    long bytesSent = object2 == null ? 0L : (l = ((BigInteger)object2).longValue());
                    object2 = ((Track.LocalTrack.LocalAudio)stat).getBytesTransported();
                    hmsStatsObserver.onLocalAudioStats(new HMSLocalAudioStats(((Track.LocalTrack.LocalAudio)stat).getRoundTripTime(), object2 == null ? null : Long.valueOf(((BigInteger)object2).longValue()), bitrate3), (HMSTrack)getTrackForId.invoke((Object)item.getKey()), (HMSPeer)getLocalPeer.invoke());
                    audioPubConnection.getAvailableOutgoingBitrates().add(bitrate3);
                    object2 = audioPubConnection;
                    ((PublishConnection)object2).setBytesSent(((PublishConnection)object2).getBytesSent() + bytesSent);
                    object2 = audioPubConnection;
                    object = ((Track.LocalTrack.LocalAudio)stat).getPacketsSent();
                    ((PublishConnection)object2).setPacketsSent(((PublishConnection)object2).getPacketsSent() + (object == null ? 0L : (Long)object));
                } else if (stat instanceof Audio) {
                    long l;
                    double bitrate4 = this.bitrateCalculator.getBitrateFromTrackUpdatePrev((Track)stat);
                    object2 = ((Audio)stat).getBytesTransported();
                    long bytesReceived = object2 == null ? 0L : (l = ((BigInteger)object2).longValue());
                    object = stat;
                    Object $this$convertBundleToStatsObserverEvents_u24lambda_u2d0 = (Audio)object;
                    boolean bl = false;
                    audioStats = new HMSRemoteAudioStats(((Audio)$this$convertBundleToStatsObserverEvents_u24lambda_u2d0).getJitter(), bytesReceived, bitrate4, ((Audio)$this$convertBundleToStatsObserverEvents_u24lambda_u2d0).getPacketsReceived(), ((Audio)$this$convertBundleToStatsObserverEvents_u24lambda_u2d0).getPacketsLost());
                    hmsStatsObserver.onRemoteAudioStats((HMSRemoteAudioStats)audioStats, (HMSTrack)getTrackForId.invoke((Object)item.getKey()), (HMSPeer)getRemotePeerForTrackId.invoke((Object)item.getKey()));
                    object = audioSubConnection;
                    ((SubscribeConnection)object).setBytesReceived(((SubscribeConnection)object).getBytesReceived() + bytesReceived);
                    audioSubConnection.getAvailableIncomingBitrates().add(bitrate4);
                    object = audioSubConnection;
                    $this$convertBundleToStatsObserverEvents_u24lambda_u2d0 = ((Audio)stat).getPacketsReceived();
                    ((SubscribeConnection)object).setPacketsReceived(((SubscribeConnection)object).getPacketsReceived() + ($this$convertBundleToStatsObserverEvents_u24lambda_u2d0 == null ? 0L : (Long)$this$convertBundleToStatsObserverEvents_u24lambda_u2d0));
                } else if (stat instanceof Video) {
                    long l;
                    double bitrate5 = this.bitrateCalculator.getBitrateFromTrackUpdatePrev((Track)stat);
                    audioStats = ((Video)stat).getBytesTransported();
                    long bytesReceived = audioStats == null ? 0L : (l = ((BigInteger)audioStats).longValue());
                    object = stat;
                    Video $this$convertBundleToStatsObserverEvents_u24lambda_u2d1 = (Video)object;
                    boolean bl = false;
                    HMSVideoResolution resolution = $this$convertBundleToStatsObserverEvents_u24lambda_u2d1.getFrameWidth() != null && $this$convertBundleToStatsObserverEvents_u24lambda_u2d1.getFrameHeight() != null ? new HMSVideoResolution((int)$this$convertBundleToStatsObserverEvents_u24lambda_u2d1.getFrameWidth().longValue(), (int)$this$convertBundleToStatsObserverEvents_u24lambda_u2d1.getFrameHeight().longValue()) : null;
                    HMSRemoteVideoStats videoStats = new HMSRemoteVideoStats($this$convertBundleToStatsObserverEvents_u24lambda_u2d1.getJitter(), bytesReceived, bitrate5, $this$convertBundleToStatsObserverEvents_u24lambda_u2d1.getPacketsReceived(), $this$convertBundleToStatsObserverEvents_u24lambda_u2d1.getPacketsLost(), resolution, $this$convertBundleToStatsObserverEvents_u24lambda_u2d1.getFramesPerSecond());
                    hmsStatsObserver.onRemoteVideoStats(videoStats, (HMSTrack)getTrackForId.invoke((Object)item.getKey()), (HMSPeer)getRemotePeerForTrackId.invoke((Object)item.getKey()));
                    object = videoSubConnection;
                    ((SubscribeConnection)object).setBytesReceived(((SubscribeConnection)object).getBytesReceived() + bytesReceived);
                    videoSubConnection.getAvailableIncomingBitrates().add(bitrate5);
                    object = videoSubConnection;
                    Long l2 = ((Video)stat).getPacketsReceived();
                    ((SubscribeConnection)object).setPacketsReceived(((SubscribeConnection)object).getPacketsReceived() + (l2 == null ? 0L : l2));
                } else if (stat instanceof ConnectionInfo.PublishConnection) {
                    bitrate5 = ((ConnectionInfo.PublishConnection)stat).getCurrentRoundTripTime();
                    publishRoundTripTime = bitrate5 == null ? 0.0 : bitrate5;
                } else if (stat instanceof ConnectionInfo.SubscribeConnection) {
                    bitrate5 = ((ConnectionInfo.SubscribeConnection)stat).getCurrentRoundTripTime();
                    subscribeRoundTripTime = bitrate5 == null ? 0.0 : bitrate5;
                } else {
                    boolean bitrate5 = false;
                    if (_Assertions.ENABLED) {
                        boolean $i$a$-assert-BundleToStatsObserver$convertBundleToStatsObserverEvents$22 = false;
                        String $i$a$-assert-BundleToStatsObserver$convertBundleToStatsObserverEvents$22 = "Should not have reached here";
                        throw new AssertionError((Object)$i$a$-assert-BundleToStatsObserver$convertBundleToStatsObserverEvents$22);
                    }
                }
            }
            HMSRTCStats allVideoHMSRTCStatsReport = new HMSRTCStats(videoPubConnection.getBytesSent(), videoSubConnection.getBytesReceived(), videoSubConnection.getPacketsReceived(), 0L, CollectionsKt.averageOfDouble((Iterable)videoPubConnection.getAvailableOutgoingBitrates()), CollectionsKt.averageOfDouble((Iterable)videoSubConnection.getAvailableIncomingBitrates()), (subscribeRoundTripTime + publishRoundTripTime) / (double)2);
            HMSRTCStats allAudioHMSRTCStatsReport = new HMSRTCStats(audioPubConnection.getBytesSent(), audioSubConnection.getBytesReceived(), audioSubConnection.getPacketsReceived(), 0L, CollectionsKt.averageOfDouble((Iterable)audioPubConnection.getAvailableOutgoingBitrates()), CollectionsKt.averageOfDouble((Iterable)audioSubConnection.getAvailableIncomingBitrates()), (subscribeRoundTripTime + publishRoundTripTime) / (double)2);
            HMSRTCStats totalHMSRtcStats = new HMSRTCStats(allAudioHMSRTCStatsReport.getBytesSent() + allVideoHMSRTCStatsReport.getBytesSent(), allAudioHMSRTCStatsReport.getBytesReceived() + allVideoHMSRTCStatsReport.getBytesReceived(), allAudioHMSRTCStatsReport.getPacketsReceived() + allVideoHMSRTCStatsReport.getPacketsReceived(), allAudioHMSRTCStatsReport.getPacketsLost() + allVideoHMSRTCStatsReport.getPacketsLost(), CollectionsKt.averageOfDouble((Iterable)CollectionsKt.plus((Collection)audioPubConnection.getAvailableOutgoingBitrates(), (Iterable)videoPubConnection.getAvailableOutgoingBitrates())), CollectionsKt.averageOfDouble((Iterable)CollectionsKt.plus((Collection)audioSubConnection.getAvailableIncomingBitrates(), (Iterable)videoSubConnection.getAvailableIncomingBitrates())), (subscribeRoundTripTime + publishRoundTripTime) / (double)2);
            HMSRTCStatsReport report = new HMSRTCStatsReport(totalHMSRtcStats, allAudioHMSRTCStatsReport, allVideoHMSRTCStatsReport);
            hmsStatsObserver.onRTCStats(report);
        }
    }
}

