/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.media.streams;

import android.app.Notification;
import android.content.Context;
import android.content.Intent;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.error.HMSException;
import live.hms.video.events.AnalyticsEventsService;
import live.hms.video.factories.HMSPeerConnectionFactory;
import live.hms.video.factories.MediaConstraintsFactory;
import live.hms.video.media.capturers.HMSAudioCapturer;
import live.hms.video.media.capturers.HMSCapturer;
import live.hms.video.media.capturers.HMSScreenCapturer;
import live.hms.video.media.capturers.HMSVideoCapturer;
import live.hms.video.media.settings.HMSAudioTrackSettings;
import live.hms.video.media.settings.HMSVideoTrackSettings;
import live.hms.video.plugin.video.HMSVideoPlugin;
import live.hms.video.plugin.video.HMSVideoPluginsManager;
import live.hms.video.sdk.HMSActionResultListener;
import live.hms.video.sdk.models.enums.AudioMixingMode;
import live.hms.video.utils.HMSLogger;
import live.hms.video.utils.IdHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.AudioSource;
import org.webrtc.AudioTrack;
import org.webrtc.PeerConnectionFactory;
import org.webrtc.VideoSource;
import org.webrtc.VideoTrack;
import org.webrtc.voiceengine.WebRtcAudioUtils;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\nJ\u001a\u0010\u0015\u001a\u0016\u0012\u0004\u0012\u00020\f\u0018\u00010\u0016j\n\u0012\u0004\u0012\u00020\f\u0018\u0001`\u0017J@\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\"\u001a\u0004\u0018\u00010#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\n0%J\u0016\u0010&\u001a\u00020'2\u0006\u0010\u001c\u001a\u00020(2\u0006\u0010)\u001a\u00020*J\u001e\u0010+\u001a\u00020,2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020-2\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010.\u001a\u00020/2\u0006\u0010\u001c\u001a\u00020(2\b\b\u0002\u00100\u001a\u000201J@\u00102\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020(2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u00103\u001a\u00020-2\b\u00104\u001a\u0004\u0018\u00010#2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\n0%J\u000e\u00106\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Llive/hms/video/media/streams/HMSStreamFactory;", "", "()V", "TAG", "", "pluginsManager", "Llive/hms/video/plugin/video/HMSVideoPluginsManager;", "videoSource", "Lorg/webrtc/VideoSource;", "addPlugin", "", "plugin", "Llive/hms/video/plugin/video/HMSVideoPlugin;", "resultListener", "Llive/hms/video/sdk/HMSActionResultListener;", "inputFrameRate", "", "pluginFrameRate", "analyticsEventsService", "Llive/hms/video/events/AnalyticsEventsService;", "clean", "getPlugins", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "makeAudioShareCapturer", "Llive/hms/video/media/capturers/HMSCapturer;", "context", "Landroid/content/Context;", "peerConnectionFactory", "Llive/hms/video/factories/HMSPeerConnectionFactory;", "audioMixingMode", "Llive/hms/video/sdk/models/enums/AudioMixingMode;", "mediaProjectionPermissionResultData", "Landroid/content/Intent;", "audioShareNotification", "Landroid/app/Notification;", "endAudioShare", "Lkotlin/Function0;", "makeLocalAudioTrack", "Lorg/webrtc/AudioTrack;", "Lorg/webrtc/PeerConnectionFactory;", "settings", "Llive/hms/video/media/settings/HMSAudioTrackSettings;", "makeLocalVideoCapturer", "Llive/hms/video/media/capturers/HMSVideoCapturer;", "Llive/hms/video/media/settings/HMSVideoTrackSettings;", "makeLocalVideoTrack", "Lorg/webrtc/VideoTrack;", "isScreenShare", "", "makeScreenShareCapturer", "hmsVideoTrackSettings", "screenShareNotification", "endScreenShare", "removePlugin", "lib_release"})
public final class HMSStreamFactory {
    @NotNull
    public static final HMSStreamFactory INSTANCE = new HMSStreamFactory();
    @NotNull
    private static final String TAG = "HMSStreamHelper";
    private static VideoSource videoSource;
    @Nullable
    private static HMSVideoPluginsManager pluginsManager;

    private HMSStreamFactory() {
    }

    @NotNull
    public final AudioTrack makeLocalAudioTrack(@NotNull PeerConnectionFactory peerConnectionFactory, @NotNull HMSAudioTrackSettings settings) {
        Intrinsics.checkNotNullParameter((Object)peerConnectionFactory, (String)"peerConnectionFactory");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        WebRtcAudioUtils.setWebRtcBasedAcousticEchoCanceler((boolean)true);
        WebRtcAudioUtils.setWebRtcBasedAutomaticGainControl((boolean)true);
        WebRtcAudioUtils.setWebRtcBasedNoiseSuppressor((boolean)true);
        AudioSource source = peerConnectionFactory.createAudioSource(MediaConstraintsFactory.INSTANCE.makeLocalAudioTrackConstraints());
        String trackId = IdHelper.INSTANCE.makeAudioMediaStreamTrackId();
        AudioTrack track = peerConnectionFactory.createAudioTrack(trackId, source);
        track.setVolume(settings.getVolume());
        HMSLogger.d(TAG, Intrinsics.stringPlus((String)"Initialized local AudioTrack with id=", (Object)trackId));
        Intrinsics.checkNotNullExpressionValue((Object)track, (String)"track");
        return track;
    }

    @NotNull
    public final VideoTrack makeLocalVideoTrack(@NotNull PeerConnectionFactory peerConnectionFactory, boolean isScreenShare) {
        Intrinsics.checkNotNullParameter((Object)peerConnectionFactory, (String)"peerConnectionFactory");
        VideoSource videoSource = peerConnectionFactory.createVideoSource(isScreenShare);
        Intrinsics.checkNotNullExpressionValue((Object)videoSource, (String)"peerConnectionFactory.createVideoSource(isScreenShare)");
        HMSStreamFactory.videoSource = videoSource;
        String trackId = IdHelper.INSTANCE.makeVideoMediaStreamTrackId();
        VideoSource videoSource2 = HMSStreamFactory.videoSource;
        if (videoSource2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"videoSource");
            throw null;
        }
        VideoTrack track = peerConnectionFactory.createVideoTrack(trackId, videoSource2);
        HMSLogger.d(TAG, Intrinsics.stringPlus((String)"Initialized local VideoTrack with id=", (Object)trackId));
        Intrinsics.checkNotNullExpressionValue((Object)track, (String)"track");
        return track;
    }

    public static /* synthetic */ VideoTrack makeLocalVideoTrack$default(HMSStreamFactory hMSStreamFactory, PeerConnectionFactory peerConnectionFactory, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return hMSStreamFactory.makeLocalVideoTrack(peerConnectionFactory, bl);
    }

    @NotNull
    public final HMSVideoCapturer makeLocalVideoCapturer(@NotNull Context context, @NotNull HMSVideoTrackSettings settings, @NotNull AnalyticsEventsService analyticsEventsService) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)analyticsEventsService, (String)"analyticsEventsService");
        VideoSource videoSource = HMSStreamFactory.videoSource;
        if (videoSource == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"videoSource");
            throw null;
        }
        return new HMSVideoCapturer(context, videoSource, settings, analyticsEventsService);
    }

    @NotNull
    public final HMSCapturer makeScreenShareCapturer(@NotNull Context context, @NotNull PeerConnectionFactory peerConnectionFactory, @Nullable Intent mediaProjectionPermissionResultData, @NotNull HMSVideoTrackSettings hmsVideoTrackSettings, @Nullable Notification screenShareNotification, @NotNull Function0<Unit> endScreenShare) {
        VideoSource videoSource;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)peerConnectionFactory, (String)"peerConnectionFactory");
        Intrinsics.checkNotNullParameter((Object)hmsVideoTrackSettings, (String)"hmsVideoTrackSettings");
        Intrinsics.checkNotNullParameter(endScreenShare, (String)"endScreenShare");
        if (HMSStreamFactory.videoSource == null) {
            videoSource = peerConnectionFactory.createVideoSource(false);
            Intrinsics.checkNotNullExpressionValue((Object)videoSource, (String)"peerConnectionFactory.createVideoSource(false)");
            HMSStreamFactory.videoSource = videoSource;
        }
        if ((videoSource = HMSStreamFactory.videoSource) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"videoSource");
            throw null;
        }
        return new HMSScreenCapturer(context, videoSource, mediaProjectionPermissionResultData, hmsVideoTrackSettings, screenShareNotification, endScreenShare);
    }

    @NotNull
    public final HMSCapturer makeAudioShareCapturer(@NotNull Context context, @NotNull HMSPeerConnectionFactory peerConnectionFactory, @NotNull AudioMixingMode audioMixingMode, @Nullable Intent mediaProjectionPermissionResultData, @Nullable Notification audioShareNotification, @NotNull Function0<Unit> endAudioShare) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)peerConnectionFactory, (String)"peerConnectionFactory");
        Intrinsics.checkNotNullParameter((Object)((Object)audioMixingMode), (String)"audioMixingMode");
        Intrinsics.checkNotNullParameter(endAudioShare, (String)"endAudioShare");
        return new HMSAudioCapturer(context, peerConnectionFactory, audioMixingMode, mediaProjectionPermissionResultData, audioShareNotification, endAudioShare);
    }

    public final void addPlugin(@NotNull HMSVideoPlugin plugin, @NotNull HMSActionResultListener resultListener, int inputFrameRate, int pluginFrameRate, @NotNull AnalyticsEventsService analyticsEventsService) {
        HMSVideoPluginsManager hMSVideoPluginsManager;
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)resultListener, (String)"resultListener");
        Intrinsics.checkNotNullParameter((Object)analyticsEventsService, (String)"analyticsEventsService");
        if (pluginsManager == null) {
            HMSLogger.INSTANCE.i("HMSVideoPluginsManager", "initializing plugin manager");
            hMSVideoPluginsManager = videoSource;
            if (hMSVideoPluginsManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"videoSource");
                throw null;
            }
            HMSVideoPluginsManager hMSVideoPluginsManager2 = pluginsManager = new HMSVideoPluginsManager((VideoSource)hMSVideoPluginsManager, analyticsEventsService);
            Intrinsics.checkNotNull((Object)hMSVideoPluginsManager2);
            hMSVideoPluginsManager2.setInputFps(inputFrameRate);
        }
        try {
            hMSVideoPluginsManager = pluginsManager;
            if (hMSVideoPluginsManager != null) {
                hMSVideoPluginsManager.addPlugin(plugin, resultListener, pluginFrameRate);
            }
        }
        catch (HMSException err) {
            HMSLogger.INSTANCE.i("HMSVideoPluginsManager", " Adding plugin " + plugin + " getting error:" + err);
            throw err;
        }
    }

    public final void removePlugin(@NotNull HMSVideoPlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        try {
            HMSVideoPluginsManager hMSVideoPluginsManager = pluginsManager;
            if (hMSVideoPluginsManager != null) {
                hMSVideoPluginsManager.removePlugin(plugin);
            }
        }
        catch (HMSException err) {
            HMSLogger.INSTANCE.i("HMSVideoPluginsManager", " Removing plugin " + plugin + " getting error: " + err);
            throw err;
        }
    }

    @Nullable
    public final ArrayList<HMSVideoPlugin> getPlugins() {
        ArrayList<HMSVideoPlugin> plugins = null;
        try {
            HMSVideoPluginsManager hMSVideoPluginsManager = pluginsManager;
            plugins = hMSVideoPluginsManager == null ? null : hMSVideoPluginsManager.getPlugins();
        }
        catch (HMSException err) {
            HMSLogger.INSTANCE.i("HMSVideoPluginsManager", Intrinsics.stringPlus((String)" List of plugins call giving error: ", (Object)err));
            throw err;
        }
        return plugins;
    }

    public final void clean() {
        HMSVideoPluginsManager hMSVideoPluginsManager = pluginsManager;
        if (hMSVideoPluginsManager != null) {
            hMSVideoPluginsManager.clean();
        }
        pluginsManager = null;
    }
}

