/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.events;

import android.annotation.SuppressLint;
import android.content.Context;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import live.hms.video.database.entity.AnalyticsEntityModel;
import live.hms.video.events.AnalyticsEvent;
import live.hms.video.events.IAnalyticsTransport;
import live.hms.video.sdk.models.enums.HMSAnalyticsEventLevel;
import live.hms.video.utils.HMSLogger;
import live.hms.video.utils.HMSUtils;
import live.hms.video.viewModels.OfflineAnalyticsManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0012J\b\u0010\u0016\u001a\u00020\u0017H\u0007J\b\u0010\u0018\u001a\u00020\u0017H\u0002J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\rJ\u000e\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0012J*\u0010\u001c\u001a\u00020\u00172\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Llive/hms/video/events/AnalyticsEventsService;", "", "context", "Landroid/content/Context;", "level", "Llive/hms/video/sdk/models/enums/HMSAnalyticsEventLevel;", "(Landroid/content/Context;Llive/hms/video/sdk/models/enums/HMSAnalyticsEventLevel;)V", "offlineAnalyticsManager", "Llive/hms/video/viewModels/OfflineAnalyticsManager;", "peerId", "", "pendingEvents", "Ljava/util/Deque;", "Llive/hms/video/events/AnalyticsEvent;", "sessionId", "token", "transports", "Ljava/util/ArrayList;", "Llive/hms/video/events/IAnalyticsTransport;", "addTransport", "", "transport", "flush", "", "flushExistingLogs", "queue", "event", "removeTransport", "updateAnalyticsParams", "Companion", "lib_release"})
public final class AnalyticsEventsService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private HMSAnalyticsEventLevel level;
    @NotNull
    private final OfflineAnalyticsManager offlineAnalyticsManager;
    @NotNull
    private String sessionId;
    @NotNull
    private String token;
    @NotNull
    private String peerId;
    @NotNull
    private final ArrayList<IAnalyticsTransport> transports;
    @NotNull
    private final Deque<AnalyticsEvent> pendingEvents;
    @NotNull
    private static final String TAG = "AnalyticsEventsService";
    private static final int cMaxBufferSize = 100;

    public AnalyticsEventsService(@NotNull Context context, @NotNull HMSAnalyticsEventLevel level) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        this.context = context;
        this.level = level;
        this.offlineAnalyticsManager = new OfflineAnalyticsManager(this.context);
        this.sessionId = "";
        this.token = "";
        this.peerId = "";
        this.flushExistingLogs();
        this.transports = new ArrayList();
        this.pendingEvents = new LinkedList();
    }

    public final boolean addTransport(@NotNull IAnalyticsTransport transport) {
        Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
        return this.transports.add(transport);
    }

    public final boolean removeTransport(@NotNull IAnalyticsTransport transport) {
        Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
        return this.transports.remove(transport);
    }

    @NotNull
    public final synchronized AnalyticsEventsService queue(@NotNull AnalyticsEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getLevel().ordinal() <= this.level.ordinal()) {
            HMSLogger.d(TAG, event + " queued");
            this.pendingEvents.addLast(event);
            if (this.pendingEvents.size() > 100) {
                AnalyticsEvent removedEvent = this.pendingEvents.removeFirst();
                HMSLogger.d(TAG, "Max buffer size reached, removing " + removedEvent + " to accommodate new events");
            }
        }
        return this;
    }

    private final void flushExistingLogs() {
        this.offlineAnalyticsManager.flushExistingLogs(this.context);
    }

    public final void updateAnalyticsParams(@Nullable String token, @Nullable String sessionId, @Nullable String peerId) {
        String it;
        String string;
        String string2 = token;
        if (string2 != null) {
            it = string = string2;
            boolean bl = false;
            this.token = it;
        }
        string2 = sessionId;
        if (string2 != null) {
            it = string = string2;
            boolean bl = false;
            this.sessionId = it;
        }
        string2 = peerId;
        if (string2 != null) {
            it = string = string2;
            boolean bl = false;
            this.peerId = peerId;
        }
    }

    public static /* synthetic */ void updateAnalyticsParams$default(AnalyticsEventsService analyticsEventsService, String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        analyticsEventsService.updateAnalyticsParams(string, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"HardwareIds"})
    public final synchronized void flush() {
        if (this.pendingEvents.isEmpty()) {
            return;
        }
        if (this.transports.isEmpty()) {
            AnalyticsEvent event;
            HMSLogger.INSTANCE.w(TAG, "No valid signalling api found to flush analytics, trying to send via REST API");
            AnalyticsEvent analyticsEvent = event = this.pendingEvents.peekFirst();
            if (analyticsEvent != null) {
                AnalyticsEvent analyticsEvent2;
                AnalyticsEvent it = analyticsEvent2 = analyticsEvent;
                boolean bl = false;
                long l = event.getTimestamp();
                Intrinsics.checkNotNullExpressionValue((Object)event, (String)"event");
                String string = HMSUtils.INSTANCE.getUniqueEventId(event);
                String string2 = HMSUtils.INSTANCE.getDeviceId(this.context);
                String string3 = event.getName();
                String string4 = this.sessionId;
                String string5 = this.peerId;
                HashMap<String, Object> hashMap = event.getProperties();
                String string6 = this.token;
                AnalyticsEntityModel logEntityModel = new AnalyticsEntityModel(l, string, string2, null, hashMap, string3, string4, string5, string6, 8, null);
                BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, logEntityModel, event, null){
                    int label;
                    final /* synthetic */ AnalyticsEventsService this$0;
                    final /* synthetic */ AnalyticsEntityModel $logEntityModel;
                    final /* synthetic */ AnalyticsEvent $event;
                    {
                        this.this$0 = $receiver;
                        this.$logEntityModel = $logEntityModel;
                        this.$event = $event;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                this.label = 1;
                                v0 = AnalyticsEventsService.access$getOfflineAnalyticsManager$p(this.this$0).flushLog(this.$logEntityModel, (Continuation<? super Boolean>)((Continuation)this));
                                if (v0 == var3_2) {
                                    return var3_2;
                                }
                                ** GOTO lbl13
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl13:
                                // 2 sources

                                if (isSuccess = ((Boolean)v0).booleanValue()) {
                                    AnalyticsEventsService.access$getPendingEvents$p(this.this$0).remove(this.$event);
                                } else {
                                    AnalyticsEventsService.access$getOfflineAnalyticsManager$p(this.this$0).persistLog(this.$logEntityModel);
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        } else {
            HMSLogger.d(TAG, "Sending analytics via websocket");
            Deque<AnalyticsEvent> deque = this.pendingEvents;
            synchronized (deque) {
                Collection collection;
                boolean bl = false;
                while (!(collection = (Collection)this.pendingEvents).isEmpty()) {
                    AnalyticsEvent event = this.pendingEvents.removeFirst();
                    Iterable $this$forEach$iv = this.transports;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        IAnalyticsTransport it = (IAnalyticsTransport)element$iv;
                        boolean bl2 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)event, (String)"event");
                        it.event(event);
                    }
                    BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, event, null){
                        int label;
                        final /* synthetic */ AnalyticsEventsService this$0;
                        final /* synthetic */ AnalyticsEvent $event;
                        {
                            this.this$0 = $receiver;
                            this.$event = $event;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    OfflineAnalyticsManager offlineAnalyticsManager = AnalyticsEventsService.access$getOfflineAnalyticsManager$p(this.this$0);
                                    AnalyticsEvent analyticsEvent = this.$event;
                                    Intrinsics.checkNotNullExpressionValue((Object)analyticsEvent, (String)"event");
                                    this.label = 1;
                                    Object object3 = offlineAnalyticsManager.deleteLogById(HMSUtils.INSTANCE.getUniqueEventId(analyticsEvent), (Continuation<? super Unit>)((Continuation)this));
                                    if (object3 != object2) return Unit.INSTANCE;
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object3 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    public static final /* synthetic */ OfflineAnalyticsManager access$getOfflineAnalyticsManager$p(AnalyticsEventsService $this) {
        return $this.offlineAnalyticsManager;
    }

    public static final /* synthetic */ Deque access$getPendingEvents$p(AnalyticsEventsService $this) {
        return $this.pendingEvents;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Llive/hms/video/events/AnalyticsEventsService$Companion;", "", "()V", "TAG", "", "cMaxBufferSize", "", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

