/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.media.streams;

import com.google.gson.annotations.SerializedName;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.connection.subscribe.HMSSubscribeConnection;
import live.hms.video.media.settings.HMSSimulcastLayer;
import live.hms.video.media.streams.HMSMediaStream;
import live.hms.video.utils.ExtensionUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.MediaStream;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0017B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0003J\u0019\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\bH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J\u0019\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\nH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014J\u0011\u0010\u0015\u001a\u00020\u000fH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0018"}, d2={"Llive/hms/video/media/streams/HMSRemoteStream;", "Llive/hms/video/media/streams/HMSMediaStream;", "nativeStream", "Lorg/webrtc/MediaStream;", "connection", "Llive/hms/video/connection/subscribe/HMSSubscribeConnection;", "(Lorg/webrtc/MediaStream;Llive/hms/video/connection/subscribe/HMSSubscribeConnection;)V", "audio", "", "frameRate", "Llive/hms/video/media/settings/HMSSimulcastLayer;", "video", "compareNative", "with", "setAudio", "", "enabled", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setVideo", "layer", "(Llive/hms/video/media/settings/HMSSimulcastLayer;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "syncWithApiChannel", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "DataChannelCallData", "lib_release"})
public final class HMSRemoteStream
extends HMSMediaStream {
    @NotNull
    private final HMSSubscribeConnection connection;
    private boolean audio;
    @NotNull
    private HMSSimulcastLayer video;
    @NotNull
    private HMSSimulcastLayer frameRate;

    public HMSRemoteStream(@NotNull MediaStream nativeStream, @NotNull HMSSubscribeConnection connection) {
        Intrinsics.checkNotNullParameter((Object)nativeStream, (String)"nativeStream");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        super(nativeStream);
        this.connection = connection;
        this.audio = true;
        this.video = HMSSimulcastLayer.HIGH;
        this.frameRate = HMSSimulcastLayer.HIGH;
    }

    @Nullable
    public final Object setAudio(boolean enabled, @NotNull Continuation<? super Unit> $completion) {
        this.audio = enabled;
        Object object = this.syncWithApiChannel($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object setVideo(@NotNull HMSSimulcastLayer layer, @NotNull Continuation<? super Unit> $completion) {
        this.video = layer;
        Object object = this.syncWithApiChannel($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final Object syncWithApiChannel(Continuation<? super Unit> $completion) {
        DataChannelCallData data = new DataChannelCallData(this.getId(), this.audio, this.video, this.frameRate);
        Object object = this.connection.sendOverApiDataChannel(ExtensionUtilsKt.toJson(data), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public final boolean compareNative(@NotNull MediaStream with) {
        Intrinsics.checkNotNullParameter((Object)with, (String)"with");
        return Intrinsics.areEqual((Object)this.getNativeStream(), (Object)with);
    }

    public static final /* synthetic */ Object access$syncWithApiChannel(HMSRemoteStream $this, Continuation $completion) {
        return $this.syncWithApiChannel((Continuation<? super Unit>)$completion);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\b\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\r\u00a8\u0006\u001b"}, d2={"Llive/hms/video/media/streams/HMSRemoteStream$DataChannelCallData;", "", "streamId", "", "audio", "", "video", "Llive/hms/video/media/settings/HMSSimulcastLayer;", "frameRate", "(Ljava/lang/String;ZLlive/hms/video/media/settings/HMSSimulcastLayer;Llive/hms/video/media/settings/HMSSimulcastLayer;)V", "getAudio", "()Z", "getFrameRate", "()Llive/hms/video/media/settings/HMSSimulcastLayer;", "getStreamId", "()Ljava/lang/String;", "getVideo", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "lib_release"})
    public static final class DataChannelCallData {
        @SerializedName(value="streamId")
        @NotNull
        private final String streamId;
        @SerializedName(value="audio")
        private final boolean audio;
        @SerializedName(value="video")
        @NotNull
        private final HMSSimulcastLayer video;
        @SerializedName(value="framerate")
        @NotNull
        private final HMSSimulcastLayer frameRate;

        public DataChannelCallData(@NotNull String streamId, boolean audio, @NotNull HMSSimulcastLayer video, @NotNull HMSSimulcastLayer frameRate) {
            Intrinsics.checkNotNullParameter((Object)streamId, (String)"streamId");
            Intrinsics.checkNotNullParameter((Object)((Object)video), (String)"video");
            Intrinsics.checkNotNullParameter((Object)((Object)frameRate), (String)"frameRate");
            this.streamId = streamId;
            this.audio = audio;
            this.video = video;
            this.frameRate = frameRate;
        }

        public /* synthetic */ DataChannelCallData(String string, boolean bl, HMSSimulcastLayer hMSSimulcastLayer, HMSSimulcastLayer hMSSimulcastLayer2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                hMSSimulcastLayer2 = HMSSimulcastLayer.HIGH;
            }
            this(string, bl, hMSSimulcastLayer, hMSSimulcastLayer2);
        }

        @NotNull
        public final String getStreamId() {
            return this.streamId;
        }

        public final boolean getAudio() {
            return this.audio;
        }

        @NotNull
        public final HMSSimulcastLayer getVideo() {
            return this.video;
        }

        @NotNull
        public final HMSSimulcastLayer getFrameRate() {
            return this.frameRate;
        }

        @NotNull
        public final String component1() {
            return this.streamId;
        }

        public final boolean component2() {
            return this.audio;
        }

        @NotNull
        public final HMSSimulcastLayer component3() {
            return this.video;
        }

        @NotNull
        public final HMSSimulcastLayer component4() {
            return this.frameRate;
        }

        @NotNull
        public final DataChannelCallData copy(@NotNull String streamId, boolean audio, @NotNull HMSSimulcastLayer video, @NotNull HMSSimulcastLayer frameRate) {
            Intrinsics.checkNotNullParameter((Object)streamId, (String)"streamId");
            Intrinsics.checkNotNullParameter((Object)((Object)video), (String)"video");
            Intrinsics.checkNotNullParameter((Object)((Object)frameRate), (String)"frameRate");
            return new DataChannelCallData(streamId, audio, video, frameRate);
        }

        public static /* synthetic */ DataChannelCallData copy$default(DataChannelCallData dataChannelCallData, String string, boolean bl, HMSSimulcastLayer hMSSimulcastLayer, HMSSimulcastLayer hMSSimulcastLayer2, int n, Object object) {
            if ((n & 1) != 0) {
                string = dataChannelCallData.streamId;
            }
            if ((n & 2) != 0) {
                bl = dataChannelCallData.audio;
            }
            if ((n & 4) != 0) {
                hMSSimulcastLayer = dataChannelCallData.video;
            }
            if ((n & 8) != 0) {
                hMSSimulcastLayer2 = dataChannelCallData.frameRate;
            }
            return dataChannelCallData.copy(string, bl, hMSSimulcastLayer, hMSSimulcastLayer2);
        }

        @NotNull
        public String toString() {
            return "DataChannelCallData(streamId=" + this.streamId + ", audio=" + this.audio + ", video=" + (Object)((Object)this.video) + ", frameRate=" + (Object)((Object)this.frameRate) + ')';
        }

        public int hashCode() {
            int result2 = this.streamId.hashCode();
            int n = this.audio ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result2 = result2 * 31 + n;
            result2 = result2 * 31 + this.video.hashCode();
            result2 = result2 * 31 + this.frameRate.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DataChannelCallData)) {
                return false;
            }
            DataChannelCallData dataChannelCallData = (DataChannelCallData)other;
            if (!Intrinsics.areEqual((Object)this.streamId, (Object)dataChannelCallData.streamId)) {
                return false;
            }
            if (this.audio != dataChannelCallData.audio) {
                return false;
            }
            if (this.video != dataChannelCallData.video) {
                return false;
            }
            return this.frameRate == dataChannelCallData.frameRate;
        }
    }
}

