/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.events;

import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import live.hms.video.database.entity.AnalyticsEntityModel;
import live.hms.video.factories.OkHttpFactory;
import live.hms.video.utils.GsonUtils;
import live.hms.video.utils.HMSLogger;
import live.hms.video.utils.HMSUtils;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0002J\u0019\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\r"}, d2={"Llive/hms/video/events/EventsApiClient;", "", "()V", "TAG", "", "makeEventRequest", "Lokhttp3/Request;", "analyticsEntityModel", "Llive/hms/video/database/entity/AnalyticsEntityModel;", "token", "reportAnalyticsEvent", "", "(Llive/hms/video/database/entity/AnalyticsEntityModel;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib_release"})
public final class EventsApiClient {
    @NotNull
    public static final EventsApiClient INSTANCE = new EventsApiClient();
    @NotNull
    private static final String TAG = "EventsApi";

    private EventsApiClient() {
    }

    private final Request makeEventRequest(AnalyticsEntityModel analyticsEntityModel, String token) {
        String agentUrlEncoded = HMSUtils.INSTANCE.getAgentUrlEncoded();
        String url = Intrinsics.stringPlus((String)"https://event.100ms.live/v2/client/report?user_agent=", (Object)agentUrlEncoded);
        MediaType mediaType = MediaType.Companion.parse("application/json; charset=utf-8");
        analyticsEntityModel.setAgent(HMSUtils.INSTANCE.getAgent());
        String jsonPayload = GsonUtils.INSTANCE.getGson().toJson((Object)analyticsEntityModel);
        Intrinsics.checkNotNullExpressionValue((Object)jsonPayload, (String)"jsonPayload");
        RequestBody body = RequestBody.Companion.create(jsonPayload, mediaType);
        Request request = new Request.Builder().url(url).addHeader("Authorization", Intrinsics.stringPlus((String)"Bearer ", (Object)token)).addHeader("Accept-Type", "application/json").post(body).build();
        HMSLogger.d(TAG, Intrinsics.stringPlus((String)"makeInitRequest: request=", (Object)request));
        return request;
    }

    @Nullable
    public final Object reportAnalyticsEvent(@NotNull AnalyticsEntityModel analyticsEntityModel, @NotNull Continuation<? super Boolean> $completion) {
        Request request = this.makeEventRequest(analyticsEntityModel, analyticsEntityModel.getToken());
        CompletableDeferred deferred = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        try {
            Response response = OkHttpFactory.INSTANCE.getClient().newCall(request).execute();
            if (response.isSuccessful()) {
                deferred.complete((Object)Boxing.boxBoolean((boolean)true));
            } else {
                deferred.complete((Object)Boxing.boxBoolean((boolean)false));
            }
        }
        catch (Exception e) {
            deferred.complete((Object)Boxing.boxBoolean((boolean)false));
        }
        return deferred.await($completion);
    }
}

