/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.audio;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.media.AudioAttributes;
import android.media.AudioDeviceInfo;
import android.media.AudioFocusRequest;
import android.media.AudioManager;
import android.os.Build;
import android.preference.PreferenceManager;
import androidx.annotation.MainThread;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import live.hms.video.audio.AudioChangeEvent;
import live.hms.video.audio.AudioManagerFocusChangeCallbacks;
import live.hms.video.audio.BluetoothErrors;
import live.hms.video.audio.HMSBluetoothManager;
import live.hms.video.events.AnalyticsEventFactory;
import live.hms.video.events.AnalyticsEventsService;
import live.hms.video.utils.HMSLogger;
import live.hms.video.utils.ThreadUtils;

public class HMSAudioManager {
    private static final String TAG = "HMSAudioManager";
    private static final String SPEAKERPHONE_AUTO = "auto";
    private static final String SPEAKERPHONE_TRUE = "true";
    private static final String SPEAKERPHONE_FALSE = "false";
    private static final String PREF_SPEAKERPHONE_KEY = "speakerphone_preference";
    private static final String PREF_SPEAKERPHONE_DEAFULT = "auto";
    private final AnalyticsEventsService analytics;
    private boolean isStarted;
    private final Context hmscontext;
    @Nullable
    private final AudioManager audioManager;
    @Nullable
    private AudioManagerEvents audioManagerEvents;
    private AudioManagerState amState;
    private int savedAudioMode = -2;
    private boolean savedIsSpeakerPhoneOn;
    private boolean savedIsMicrophoneMute;
    private boolean hasWiredHeadset;
    private AudioDevice defaultAudioDevice;
    private AudioDevice selectedAudioDevice;
    private AudioDevice userSelectedAudioDevice;
    @Nullable
    private final String useSpeakerphone;
    private final HMSBluetoothManager bluetoothManager;
    private Set<AudioDevice> audioDevices = new HashSet<AudioDevice>();
    private final BroadcastReceiver wiredHeadsetReceiver;
    @Nullable
    private AudioManager.OnAudioFocusChangeListener audioFocusChangeListener;
    private final List<AudioManagerFocusChangeCallbacks> focusChangeCallbacks = new ArrayList<AudioManagerFocusChangeCallbacks>();

    public boolean isStarted() {
        return this.isStarted;
    }

    public void addAudioFocusChangeCallback(AudioManagerFocusChangeCallbacks callback) {
        this.focusChangeCallbacks.add(callback);
    }

    public void removeAudioFocusChangeCallback(AudioManagerFocusChangeCallbacks callback) {
        this.focusChangeCallbacks.remove(callback);
    }

    private void onProximitySensorChangedState() {
        if (!this.useSpeakerphone.equals("auto")) {
            return;
        }
    }

    @MainThread
    public HMSAudioManager(Context context, AnalyticsEventsService analytics) {
        this.analytics = analytics;
        this.hmscontext = context;
        this.audioManager = (AudioManager)context.getSystemService("audio");
        this.bluetoothManager = HMSBluetoothManager.create(context, this);
        this.wiredHeadsetReceiver = new WiredHeadsetReceiver();
        this.amState = AudioManagerState.UNINITIALIZED;
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        this.useSpeakerphone = sharedPreferences.getString(PREF_SPEAKERPHONE_KEY, "auto");
        HMSLogger.d(TAG, "useSpeakerphone: " + this.useSpeakerphone);
        this.defaultAudioDevice = this.useSpeakerphone.equals(SPEAKERPHONE_FALSE) ? AudioDevice.EARPIECE : AudioDevice.SPEAKER_PHONE;
        HMSLogger.d(TAG, "defaultAudioDevice: " + (Object)((Object)this.defaultAudioDevice));
        HMSLogger.logDeviceInfo(TAG);
    }

    @SuppressLint(value={"WrongConstant"})
    @MainThread
    public void start(BluetoothErrors bluetoothErrors, AudioManagerEvents audioManagerEvents) {
        int result;
        HMSLogger.d(TAG, "start HMSAudioManager");
        if (this.amState == AudioManagerState.RUNNING) {
            HMSLogger.e(TAG, "AudioManager is already active");
            return;
        }
        HMSLogger.d(TAG, "AudioManager starts...");
        this.audioManagerEvents = audioManagerEvents;
        this.amState = AudioManagerState.RUNNING;
        this.savedAudioMode = this.audioManager.getMode();
        this.savedIsSpeakerPhoneOn = this.audioManager.isSpeakerphoneOn();
        this.savedIsMicrophoneMute = this.audioManager.isMicrophoneMute();
        this.hasWiredHeadset = this.hasWiredHeadset();
        this.audioFocusChangeListener = new AudioManager.OnAudioFocusChangeListener(){

            public void onAudioFocusChange(int focusChange) {
                String typeOfChange;
                switch (focusChange) {
                    case 1: {
                        typeOfChange = "AUDIOFOCUS_GAIN";
                        HMSAudioManager.this.sendAudioChangeEvent(AudioChangeEvent.AUDIOFOCUS_GAIN);
                        HMSLogger.d(HMSAudioManager.TAG, "Throwing away currently saved devices (forcing new device for onDeviceUpdate) since the audio was gained again.");
                        HMSAudioManager.this.audioDevices = new HashSet();
                        HMSAudioManager.this.updateAudioDeviceState();
                        break;
                    }
                    case 2: {
                        typeOfChange = "AUDIOFOCUS_GAIN_TRANSIENT";
                        HMSAudioManager.this.sendAudioChangeEvent(AudioChangeEvent.DEBUG_AUDIOFOCUS_GAIN_TRANSIENT);
                        break;
                    }
                    case 4: {
                        typeOfChange = "AUDIOFOCUS_GAIN_TRANSIENT_EXCLUSIVE";
                        HMSAudioManager.this.sendAudioChangeEvent(AudioChangeEvent.DEBUG_AUDIOFOCUS_GAIN_EXCLUSIVE);
                        break;
                    }
                    case 3: {
                        typeOfChange = "AUDIOFOCUS_GAIN_TRANSIENT_MAY_DUCK";
                        HMSAudioManager.this.sendAudioChangeEvent(AudioChangeEvent.DEBUG_AUDIOFOCUS_GAIN_TRANSIENT_MAY_DUCK);
                        break;
                    }
                    case -1: {
                        typeOfChange = "AUDIOFOCUS_LOSS";
                        HMSAudioManager.this.sendAudioChangeEvent(AudioChangeEvent.DEBUG_AUDIOFOCUS_LOSS);
                        break;
                    }
                    case -2: {
                        typeOfChange = "AUDIOFOCUS_LOSS_TRANSIENT";
                        HMSAudioManager.this.sendAudioChangeEvent(AudioChangeEvent.AUDIOFOCUS_LOSS_TRANSIENT);
                        break;
                    }
                    case -3: {
                        typeOfChange = "AUDIOFOCUS_LOSS_TRANSIENT_CAN_DUCK";
                        HMSAudioManager.this.sendAudioChangeEvent(AudioChangeEvent.DEBUG_AUDIOFOCUS_LOSS_TRANSIENT_CAN_DUCK);
                        break;
                    }
                    default: {
                        typeOfChange = "AUDIOFOCUS_INVALID";
                        HMSAudioManager.this.sendAudioChangeEvent(AudioChangeEvent.DEBUG_INVALID);
                    }
                }
                HMSLogger.d(HMSAudioManager.TAG, "onAudioFocusChange: " + typeOfChange);
            }
        };
        if (Build.VERSION.SDK_INT >= 26) {
            this.analytics.queue(AnalyticsEventFactory.INSTANCE.audioFocusStarted(System.currentTimeMillis(), false));
            AudioAttributes audioAttributes = new AudioAttributes.Builder().setUsage(2).setContentType(1).build();
            AudioFocusRequest audioFocusRequest = new AudioFocusRequest.Builder(2).setAcceptsDelayedFocusGain(true).setAudioAttributes(audioAttributes).setOnAudioFocusChangeListener(this.audioFocusChangeListener).build();
            result = this.audioManager.requestAudioFocus(audioFocusRequest);
        } else {
            this.analytics.queue(AnalyticsEventFactory.INSTANCE.audioFocusStarted(System.currentTimeMillis(), true));
            result = this.audioManager.requestAudioFocus(this.audioFocusChangeListener, 0, 2);
        }
        if (result == 1) {
            HMSLogger.d(TAG, "Audio focus request granted for VOICE_CALL streams");
        } else {
            HMSLogger.e(TAG, "Audio focus request failed");
        }
        this.audioManager.setMode(3);
        this.setMicrophoneMute(false);
        this.userSelectedAudioDevice = AudioDevice.NONE;
        this.selectedAudioDevice = AudioDevice.NONE;
        this.audioDevices.clear();
        this.bluetoothManager.start(bluetoothErrors);
        this.updateAudioDeviceState();
        this.registerReceiver(this.wiredHeadsetReceiver, new IntentFilter("android.intent.action.HEADSET_PLUG"));
        HMSLogger.d(TAG, "AudioManager started");
        this.isStarted = true;
    }

    private void sendAudioChangeEvent(AudioChangeEvent event) {
        for (AudioManagerFocusChangeCallbacks callback : this.focusChangeCallbacks) {
            callback.onAudioFocusChange(event);
        }
    }

    @SuppressLint(value={"WrongConstant"})
    @MainThread
    public void stop() {
        HMSLogger.d(TAG, "stop");
        if (this.amState != AudioManagerState.RUNNING) {
            HMSLogger.e(TAG, "Trying to stop AudioManager in incorrect state: " + (Object)((Object)this.amState));
            return;
        }
        this.amState = AudioManagerState.UNINITIALIZED;
        this.unregisterReceiver(this.wiredHeadsetReceiver);
        this.bluetoothManager.stop();
        this.setSpeakerphoneOn(this.savedIsSpeakerPhoneOn);
        this.setMicrophoneMute(this.savedIsMicrophoneMute);
        this.audioManager.setMode(this.savedAudioMode);
        this.audioManager.abandonAudioFocus(this.audioFocusChangeListener);
        this.audioFocusChangeListener = null;
        HMSLogger.d(TAG, "Abandoned audio focus for VOICE_CALL streams");
        this.audioManagerEvents = null;
        HMSLogger.d(TAG, "AudioManager stopped");
        this.isStarted = false;
    }

    private void setAudioDeviceInternal(AudioDevice device) {
        HMSLogger.d(TAG, "setAudioDeviceInternal(device=" + (Object)((Object)device) + ")");
        this.assertIsTrue(this.audioDevices.contains((Object)device));
        switch (device) {
            case SPEAKER_PHONE: {
                this.setSpeakerphoneOn(true);
                break;
            }
            case EARPIECE: {
                this.setSpeakerphoneOn(false);
                break;
            }
            case WIRED_HEADSET: {
                this.setSpeakerphoneOn(false);
                break;
            }
            case BLUETOOTH: {
                this.setSpeakerphoneOn(false);
                break;
            }
            default: {
                HMSLogger.e(TAG, "Invalid audio device selection");
            }
        }
        this.selectedAudioDevice = device;
    }

    private void assertIsTrue(boolean condition) {
        if (!condition) {
            throw new AssertionError((Object)"Expected condition to be true");
        }
    }

    @MainThread
    public void setDefaultAudioDevice(AudioDevice defaultDevice) {
        switch (defaultDevice) {
            case SPEAKER_PHONE: {
                this.defaultAudioDevice = defaultDevice;
                break;
            }
            case EARPIECE: {
                if (this.hasEarpiece()) {
                    this.defaultAudioDevice = defaultDevice;
                    break;
                }
                this.defaultAudioDevice = AudioDevice.SPEAKER_PHONE;
                break;
            }
            default: {
                HMSLogger.e(TAG, "Invalid default audio device selection");
            }
        }
        HMSLogger.d(TAG, "setDefaultAudioDevice(device=" + (Object)((Object)this.defaultAudioDevice) + ")");
        this.updateAudioDeviceState();
    }

    @MainThread
    public void selectAudioDevice(AudioDevice device) {
        if (!this.audioDevices.contains((Object)device)) {
            HMSLogger.e(TAG, "Can not select " + (Object)((Object)device) + " from available " + this.audioDevices);
        }
        this.userSelectedAudioDevice = device;
        this.updateAudioDeviceState();
    }

    @MainThread
    public Set<AudioDevice> getAudioDevices() {
        return Collections.unmodifiableSet(new HashSet<AudioDevice>(this.audioDevices));
    }

    @MainThread
    public AudioDevice getSelectedAudioDevice() {
        return this.selectedAudioDevice;
    }

    private void registerReceiver(BroadcastReceiver receiver, IntentFilter filter2) {
        this.hmscontext.registerReceiver(receiver, filter2);
    }

    private void unregisterReceiver(BroadcastReceiver receiver) {
        this.hmscontext.unregisterReceiver(receiver);
    }

    private void setSpeakerphoneOn(boolean on) {
        boolean wasOn = this.audioManager.isSpeakerphoneOn();
        if (wasOn == on) {
            return;
        }
        this.audioManager.setSpeakerphoneOn(on);
    }

    private void setMicrophoneMute(boolean on) {
        boolean wasMuted = this.audioManager.isMicrophoneMute();
        if (wasMuted == on) {
            return;
        }
        this.audioManager.setMicrophoneMute(on);
    }

    private boolean hasEarpiece() {
        return this.hmscontext.getPackageManager().hasSystemFeature("android.hardware.telephony");
    }

    @Deprecated
    private boolean hasWiredHeadset() {
        AudioDeviceInfo[] devices;
        if (Build.VERSION.SDK_INT < 23) {
            return this.audioManager.isWiredHeadsetOn();
        }
        for (AudioDeviceInfo device : devices = this.audioManager.getDevices(3)) {
            int type = device.getType();
            if (type == 3) {
                HMSLogger.d(TAG, "hasWiredHeadset: found wired headset");
                return true;
            }
            if (type != 11) continue;
            HMSLogger.d(TAG, "hasWiredHeadset: found USB audio device");
            return true;
        }
        return false;
    }

    @MainThread
    public void updateAudioDeviceState() {
        AudioDevice newAudioDevice;
        boolean needBluetoothAudioStop;
        HMSLogger.d(TAG, "--- updateAudioDeviceState: wired headset=" + this.hasWiredHeadset + ", BT state=" + (Object)((Object)this.bluetoothManager.getState()));
        HMSLogger.d(TAG, "Device status: available=" + this.audioDevices + ", selected=" + (Object)((Object)this.selectedAudioDevice) + ", user selected=" + (Object)((Object)this.userSelectedAudioDevice));
        if (this.bluetoothManager.getState() == HMSBluetoothManager.State.HEADSET_AVAILABLE || this.bluetoothManager.getState() == HMSBluetoothManager.State.HEADSET_UNAVAILABLE || this.bluetoothManager.getState() == HMSBluetoothManager.State.SCO_DISCONNECTING) {
            this.bluetoothManager.updateDevice();
        }
        HashSet<AudioDevice> newAudioDevices = new HashSet<AudioDevice>();
        if (this.bluetoothManager.getState() == HMSBluetoothManager.State.SCO_CONNECTED || this.bluetoothManager.getState() == HMSBluetoothManager.State.SCO_CONNECTING || this.bluetoothManager.getState() == HMSBluetoothManager.State.HEADSET_AVAILABLE) {
            newAudioDevices.add(AudioDevice.BLUETOOTH);
        }
        if (this.hasWiredHeadset) {
            newAudioDevices.add(AudioDevice.WIRED_HEADSET);
        } else {
            newAudioDevices.add(AudioDevice.SPEAKER_PHONE);
            if (this.hasEarpiece()) {
                newAudioDevices.add(AudioDevice.EARPIECE);
            }
        }
        boolean audioDeviceSetUpdated = !this.audioDevices.equals(newAudioDevices);
        this.audioDevices = newAudioDevices;
        if (this.bluetoothManager.getState() == HMSBluetoothManager.State.HEADSET_UNAVAILABLE && this.userSelectedAudioDevice == AudioDevice.BLUETOOTH) {
            this.userSelectedAudioDevice = AudioDevice.NONE;
        }
        if (this.hasWiredHeadset && this.userSelectedAudioDevice == AudioDevice.SPEAKER_PHONE) {
            this.userSelectedAudioDevice = AudioDevice.WIRED_HEADSET;
        }
        if (!this.hasWiredHeadset && this.userSelectedAudioDevice == AudioDevice.WIRED_HEADSET) {
            this.userSelectedAudioDevice = AudioDevice.SPEAKER_PHONE;
        }
        boolean needBluetoothAudioStart = this.bluetoothManager.getState() == HMSBluetoothManager.State.HEADSET_AVAILABLE && (this.userSelectedAudioDevice == AudioDevice.NONE || this.userSelectedAudioDevice == AudioDevice.BLUETOOTH);
        boolean bl = needBluetoothAudioStop = (this.bluetoothManager.getState() == HMSBluetoothManager.State.SCO_CONNECTED || this.bluetoothManager.getState() == HMSBluetoothManager.State.SCO_CONNECTING) && this.userSelectedAudioDevice != AudioDevice.NONE && this.userSelectedAudioDevice != AudioDevice.BLUETOOTH;
        if (this.bluetoothManager.getState() == HMSBluetoothManager.State.HEADSET_AVAILABLE || this.bluetoothManager.getState() == HMSBluetoothManager.State.SCO_CONNECTING || this.bluetoothManager.getState() == HMSBluetoothManager.State.SCO_CONNECTED) {
            HMSLogger.d(TAG, "Need BT audio: start=" + needBluetoothAudioStart + ", stop=" + needBluetoothAudioStop + ", BT state=" + (Object)((Object)this.bluetoothManager.getState()));
        }
        if (needBluetoothAudioStop) {
            this.bluetoothManager.stopScoAudio();
            this.bluetoothManager.updateDevice();
        }
        if (needBluetoothAudioStart && !needBluetoothAudioStop && !this.bluetoothManager.startScoAudio()) {
            this.audioDevices.remove((Object)AudioDevice.BLUETOOTH);
            audioDeviceSetUpdated = true;
        }
        if ((newAudioDevice = this.bluetoothManager.getState() == HMSBluetoothManager.State.SCO_CONNECTED ? AudioDevice.BLUETOOTH : (this.hasWiredHeadset ? AudioDevice.WIRED_HEADSET : this.defaultAudioDevice)) != this.selectedAudioDevice || audioDeviceSetUpdated) {
            this.setAudioDeviceInternal(newAudioDevice);
            HMSLogger.d(TAG, "New device status: available=" + this.audioDevices + ", selected=" + (Object)((Object)newAudioDevice));
            if (this.audioManagerEvents != null) {
                this.audioManagerEvents.onAudioDeviceChanged(this.selectedAudioDevice, this.audioDevices);
            }
            this.analytics.queue(AnalyticsEventFactory.INSTANCE.selectedAudioDevice(newAudioDevice));
        }
        HMSLogger.d(TAG, "--- updateAudioDeviceState done");
    }

    private class WiredHeadsetReceiver
    extends BroadcastReceiver {
        private static final int STATE_UNPLUGGED = 0;
        private static final int STATE_PLUGGED = 1;
        private static final int HAS_NO_MIC = 0;
        private static final int HAS_MIC = 1;

        private WiredHeadsetReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            int state2 = intent.getIntExtra("state", 0);
            int microphone = intent.getIntExtra("microphone", 0);
            String name = intent.getStringExtra("name");
            HMSLogger.d(HMSAudioManager.TAG, "WiredHeadsetReceiver.onReceive" + ThreadUtils.getThreadInfo() + ": a=" + intent.getAction() + ", s=" + (state2 == 0 ? "unplugged" : "plugged") + ", m=" + (microphone == 1 ? "mic" : "no mic") + ", n=" + name + ", sb=" + this.isInitialStickyBroadcast());
            HMSAudioManager.this.hasWiredHeadset = state2 == 1;
            HMSAudioManager.this.updateAudioDeviceState();
        }
    }

    public static interface AudioManagerEvents {
        public void onAudioDeviceChanged(AudioDevice var1, Set<AudioDevice> var2);
    }

    public static enum AudioManagerState {
        UNINITIALIZED,
        PREINITIALIZED,
        RUNNING;

    }

    public static enum AudioDevice {
        SPEAKER_PHONE,
        WIRED_HEADSET,
        EARPIECE,
        BLUETOOTH,
        NONE;

    }
}

