/*
 * Decompiled with CFR 0.152.
 */
package link.thingscloud.spring.boot.common.redis;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.thread.ThreadUtil;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import link.thingscloud.spring.boot.common.redis.callback.RedisResponseCallback;
import link.thingscloud.spring.boot.common.util.ExecutorHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.stereotype.Component;

@Component
public class SimpleDistributedLocker {
    private static final Logger log = LoggerFactory.getLogger(SimpleDistributedLocker.class);
    @Value(value="${simple.distributed.locker.sleepTimeout:10}")
    private long sleepTimeoutMillis;
    @Value(value="${simple.distributed.locker.lockTimeout:1000}")
    private long lockTimeoutMillis;
    @Value(value="${simple.distributed.locker.expiredTimeout:60000}")
    private long expiredTimeoutMillis;
    @Value(value="${simple.distributed.locker.key:simple:distributed:locker:}")
    private String lockerKey;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    private final boolean isTraceEnabled = log.isTraceEnabled();
    private final Map<String, Long> expiredKeyMap = new ConcurrentHashMap<String, Long>(16);
    private static final RedisScript<Long> DELETE_VALUE_REDIS_SCRIPT = new DefaultRedisScript("if redis.call('GET', KEYS[1]) == ARGV[1] then  return redis.call('DEL', KEYS[1]) else return -1 end", Long.class);

    @PostConstruct
    public void startup() {
        long intervalTimeMillis = this.expiredTimeoutMillis / 2L - 2L;
        ExecutorHelper.scheduleAtFixedRate(() -> {
            log.debug("scheduleAtFixedRate running at {}", (Object)DateUtil.now());
            long timeMillis = System.currentTimeMillis();
            this.expiredKeyMap.forEach((key, expiredTimeMillis) -> {
                if (expiredTimeMillis - timeMillis < intervalTimeMillis) {
                    try {
                        this.stringRedisTemplate.expire(key, this.expiredTimeoutMillis, TimeUnit.MILLISECONDS);
                        log.info("scheduleAtFixedRate expire key : [{}], expiredTimeMillis : {} ms", key, expiredTimeMillis);
                    }
                    catch (Exception e) {
                        log.error("scheduleAtFixedRate expire key : [{}], expiredTimeMillis : {} ms", new Object[]{key, expiredTimeMillis, e});
                    }
                }
            });
        }, (long)intervalTimeMillis, (long)intervalTimeMillis, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryLock(String key, RedisResponseCallback callback) {
        Boolean lock;
        String key0 = this.lockerKey + key;
        String value = DateUtil.now();
        long start = System.currentTimeMillis();
        try {
            lock = this.tryLock(key0, value, this.expiredTimeoutMillis);
        }
        catch (Exception e) {
            callback.onException(e);
            return;
        }
        if (lock != null && lock.booleanValue()) {
            try {
                this.expiredKeyMap.put(key0, start + this.expiredTimeoutMillis);
                callback.onSucceed();
                long cost = System.currentTimeMillis() - start;
                log.debug("tryLock key : {}, expired timeout : {} ms, cost : {} ms", new Object[]{key, this.expiredTimeoutMillis, cost});
            }
            catch (Exception e) {
                callback.onException(e);
            }
            finally {
                this.expiredKeyMap.remove(key0);
                this.deleteLock(key0, value);
            }
        } else {
            callback.onFailure();
        }
    }

    public void lock(String key, RedisResponseCallback callback) {
        this.lock(key, this.lockTimeoutMillis, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(String key, long lockTimeoutMillis, RedisResponseCallback callback) {
        Boolean lock;
        int tryTimes = 0;
        String key0 = this.lockerKey + key;
        String value = DateUtil.now();
        try {
            lock = this.tryLock(key0, value, this.expiredTimeoutMillis);
            while (!lock.booleanValue() && lockTimeoutMillis > 0L) {
                ++tryTimes;
                lockTimeoutMillis -= this.sleepTimeoutMillis;
                ThreadUtil.sleep((long)this.sleepTimeoutMillis);
                lock = this.tryLock(key0, value, this.expiredTimeoutMillis);
            }
        }
        catch (Exception e) {
            callback.onException(e);
            return;
        }
        if (lock.booleanValue()) {
            try {
                long start = System.currentTimeMillis();
                this.expiredKeyMap.put(key0, start + this.expiredTimeoutMillis);
                callback.onSucceed();
                long cost = System.currentTimeMillis() - start;
                log.debug("lock key : {}, lock timeout : {} ms, expired timeout : {} ms, tryTimes : {}, cost : {} ms", new Object[]{key, lockTimeoutMillis, this.expiredTimeoutMillis, tryTimes, cost});
            }
            catch (Exception e) {
                callback.onException(e);
            }
            finally {
                this.expiredKeyMap.remove(key0);
                this.deleteLock(key0, value);
            }
        } else {
            callback.onFailure();
        }
    }

    private Boolean tryLock(String key, String value, long timeoutMillis) {
        return this.stringRedisTemplate.opsForValue().setIfAbsent((Object)key, (Object)value, timeoutMillis, TimeUnit.MILLISECONDS);
    }

    private void deleteLock(String key, String value) {
        this.stringRedisTemplate.execute(DELETE_VALUE_REDIS_SCRIPT, Collections.singletonList(key), new Object[]{value});
    }
}

