/*
 * Decompiled with CFR 0.152.
 */
package link.thingscloud.spring.boot.common.redis;

import cn.hutool.core.util.IdUtil;
import io.lettuce.core.internal.LettuceLists;
import java.util.ArrayList;
import java.util.List;
import link.thingscloud.spring.boot.common.util.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.stereotype.Component;

@Component
public class SimpleDistributedLimiter {
    private static final Logger log = LoggerFactory.getLogger(SimpleDistributedLimiter.class);
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    private static final String DEFAULT = "default";
    private static final String KEY_PREFIX = "simple:distributed:limiter:";
    private static final RedisScript<Long> SIMPLE_DISTRIBUTED_LIMITER_REDIS_SCRIPT = new DefaultRedisScript("if redis.call('HLEN', KEYS[1]) < tonumber(KEYS[2]) then  return redis.call('HSET', KEYS[1], ARGV[1], ARGV[2]) else return -1 end", Long.class);

    public boolean permit(int permits) {
        return this.permit(DEFAULT, permits);
    }

    public boolean permit(String key, int permits) {
        return this.permit(key, IdUtil.fastSimpleUUID(), permits);
    }

    public boolean permit(String key, String hashKey, int permits) {
        try {
            Long result = (Long)this.stringRedisTemplate.execute(SIMPLE_DISTRIBUTED_LIMITER_REDIS_SCRIPT, LettuceLists.newList((Object[])new String[]{KEY_PREFIX + key, String.valueOf(permits)}), new Object[]{hashKey, SystemClock.strNow()});
            return result != null && result > 0L;
        }
        catch (Exception e) {
            log.error("permit key [{}] hashKey [{}] permits [{}] failed, cause : ", new Object[]{key, hashKey, permits, e});
            return false;
        }
    }

    public boolean permit0(String key, String hashKey, String hashValue, int permits, List<String> hashKeys, int maxPermits) {
        StringBuilder sb = new StringBuilder();
        sb.append("local value = redis.call('HLEN', KEYS[1]) ");
        sb.append("if value < tonumber(KEYS[2]) then ");
        if (hashKeys != null) {
            for (String hashKey0 : hashKeys) {
                sb.append(" value = value + redis.call('HLEN', '").append(hashKey0).append("') ");
            }
            sb.append(" if value < tonumber(KEYS[3]) then ");
            sb.append("  return redis.call('HSET', KEYS[1], ARGV[1], ARGV[2]) ");
            sb.append(" else ");
            sb.append("  return -1 ");
            sb.append(" end ");
        } else {
            sb.append(" return redis.call('HSET', KEYS[1], ARGV[1], ARGV[2]) ");
        }
        sb.append("else");
        sb.append(" return -2 ");
        sb.append("end");
        try {
            Long result = (Long)this.stringRedisTemplate.execute((RedisScript)new DefaultRedisScript(sb.toString(), Long.class), LettuceLists.newList((Object[])new String[]{key, String.valueOf(permits), String.valueOf(maxPermits)}), new Object[]{hashKey, hashValue});
            return result != null && result > 0L;
        }
        catch (Exception e) {
            log.error("permit key [{}] hashKey [{}] permits [{}] failed, cause : ", new Object[]{key, hashKey, permits, e});
            return false;
        }
    }

    public List<String> clear(long expiredMillis) {
        return this.clear(DEFAULT, expiredMillis);
    }

    public List<String> clear(String key, long expiredMillis) {
        ArrayList<String> list = new ArrayList<String>(8);
        this.stringRedisTemplate.opsForHash().entries((Object)(KEY_PREFIX + key)).forEach((key1, value) -> {
            if (SystemClock.now() - Long.parseLong(value) > expiredMillis) {
                list.add((String)key1);
            }
        });
        if (!list.isEmpty()) {
            this.stringRedisTemplate.opsForHash().delete((Object)(KEY_PREFIX + key), list.toArray());
        }
        return list;
    }

    public Boolean delete(String key) {
        return this.stringRedisTemplate.delete((Object)(KEY_PREFIX + key));
    }
}

