/*
 * Decompiled with CFR 0.152.
 */
package link.thingscloud.spring.boot.common.redis.simple;

import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import link.thingscloud.spring.boot.common.redis.RedisMessageListenerAdapter;
import link.thingscloud.spring.boot.common.redis.RedisTemplate0;
import link.thingscloud.spring.boot.common.util.ExecutorHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SimpleRedisMessageListener
extends RedisMessageListenerAdapter {
    private static final Logger log = LoggerFactory.getLogger(SimpleRedisMessageListener.class);
    @Autowired
    private RedisTemplate0 redisTemplate0;

    @Override
    public String getTopic() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void handleMessage(String message, String channel) {
        log.info("handleMessage channel : {}, message : {}", (Object)channel, (Object)message);
    }

    @PostConstruct
    public void startup() {
        ExecutorHelper.schedule(() -> this.redisTemplate0.convertAndSend(this.getClass().getSimpleName(), "Hello"), (long)5L, (TimeUnit)TimeUnit.SECONDS);
    }
}

