/*
 * Decompiled with CFR 0.152.
 */
package link.thingscloud.spring.boot.common.redis;

import java.util.List;
import link.thingscloud.spring.boot.common.redis.RedisMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.listener.PatternTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;

@Configuration
public class RedisMessageListenerConfig {
    private static final Logger log = LoggerFactory.getLogger(RedisMessageListenerConfig.class);
    @Autowired
    private List<RedisMessageListener> redisMessageListeners;

    @Bean
    public RedisMessageListenerContainer redisMessageListenerContainer(RedisConnectionFactory connectionFactory) {
        RedisMessageListenerContainer container = new RedisMessageListenerContainer();
        container.setConnectionFactory(connectionFactory);
        this.redisMessageListeners.forEach(listener -> {
            log.info("redis message listener topic : {}, listener : {}", (Object)listener.getTopic(), (Object)listener.getClass().getName());
            container.addMessageListener((MessageListener)listener, (Topic)new PatternTopic(listener.getTopic()));
        });
        return container;
    }
}

