/*
 * Decompiled with CFR 0.152.
 */
package com.liji.imagezoom.util;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Bundle;
import android.support.design.widget.BottomSheetBehavior;
import android.support.design.widget.BottomSheetDialog;
import android.support.design.widget.BottomSheetDialogFragment;
import android.support.design.widget.CoordinatorLayout;
import android.support.v4.app.FragmentManager;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class BottomMenuDialog
extends BottomSheetDialogFragment
implements View.OnClickListener {
    private static final String TAG = BottomMenuDialog.class.getName();
    private ArrayList<String> titles;
    private Map<String, View.OnClickListener> listeners;
    private int textColor = -16777216;
    private LinearLayout rootView;
    protected Dialog dialog;
    private Context mContext;
    protected BottomSheetBehavior mBehavior;

    public BottomMenuDialog() {
    }

    @SuppressLint(value={"ValidFragment"})
    public BottomMenuDialog(Builder builder) {
        this.titles = builder.titles;
        this.listeners = builder.listeners;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        this.mContext = context;
    }

    public void onCreate(Bundle savedInstanceState) {
        this.textColor = Color.parseColor((String)"#333333");
        super.onCreate(savedInstanceState);
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
    }

    public void onStart() {
        super.onStart();
        Window window = this.getDialog().getWindow();
        WindowManager.LayoutParams windowParams = window.getAttributes();
        windowParams.dimAmount = 0.5f;
        window.setAttributes(windowParams);
        this.mBehavior.setState(3);
    }

    public void onDestroy() {
        super.onDestroy();
        ((ViewGroup)this.rootView.getParent()).removeView((View)this.rootView);
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        this.dialog = new BottomSheetDialog(this.getContext(), this.getTheme());
        if (this.rootView == null) {
            this.initRootView();
        }
        this.dialog.setContentView((View)this.rootView);
        View parentView = (View)this.rootView.getParent();
        CoordinatorLayout.LayoutParams params = (CoordinatorLayout.LayoutParams)parentView.getLayoutParams();
        params.gravity = 49;
        parentView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mBehavior = BottomSheetBehavior.from((View)parentView);
        this.rootView.measure(0, 0);
        this.mBehavior.setHideable(true);
        ((View)this.rootView.getParent()).setBackgroundColor(0);
        this.rootView.post(new Runnable(){

            @Override
            public void run() {
                BottomMenuDialog.this.mBehavior.setPeekHeight(BottomMenuDialog.this.rootView.getHeight());
            }
        });
        return this.dialog;
    }

    private void initRootView() {
        this.rootView = new LinearLayout(this.mContext);
        this.rootView.setOrientation(1);
        this.rootView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.rootView.setPadding(BottomMenuDialog.dp2px(this.mContext, 10.0f), 0, BottomMenuDialog.dp2px(this.mContext, 10.0f), BottomMenuDialog.dp2px(this.mContext, 10.0f));
        if (this.titles == null || this.titles.size() == 0) {
            return;
        }
        if (this.titles.size() == 1) {
            View childView = this.initView(this.titles.get(0), 1, false, false);
            childView.setBackgroundDrawable((Drawable)this.getDrawableListByType(true, true, true, true));
            return;
        }
        if (this.titles.size() == 2) {
            View childView = this.initView(this.titles.get(0), 1, false, true);
            childView.setBackgroundDrawable((Drawable)this.getDrawableListByType(true, true, true, true));
            childView = this.initView(this.titles.get(1), 2, false, false);
            childView.setBackgroundDrawable((Drawable)this.getDrawableListByType(true, true, true, true));
            return;
        }
        for (int i = 0; i < this.titles.size(); ++i) {
            View childView = null;
            if (i == 0) {
                childView = this.initView(this.titles.get(0), i + 1, true, false);
                childView.setBackgroundDrawable((Drawable)this.getDrawableListByType(true, true, false, false));
                continue;
            }
            if (i == this.titles.size() - 2) {
                childView = this.initView(this.titles.get(i), i + 1, false, true);
                childView.setBackgroundDrawable((Drawable)this.getDrawableListByType(false, false, true, true));
                continue;
            }
            if (i == this.titles.size() - 1) {
                childView = this.initView(this.titles.get(i), i + 1, false, false);
                childView.setBackgroundDrawable((Drawable)this.getDrawableListByType(true, true, true, true));
                continue;
            }
            childView = this.initView(this.titles.get(i), i + 1, true, false);
            childView.setBackgroundDrawable((Drawable)this.getDrawableListByType(false, false, false, false));
        }
    }

    private View initView(String button, int position, boolean hasBottomLine, boolean hasBottomGap) {
        TextView childView = new TextView(this.mContext);
        childView.setText((CharSequence)button);
        childView.setTextSize(18.0f);
        childView.setTextColor(this.textColor);
        childView.setTag((Object)position);
        childView.setGravity(17);
        childView.setOnClickListener((View.OnClickListener)this);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, BottomMenuDialog.dp2px(this.mContext, 50.0f));
        if (hasBottomGap) {
            params.bottomMargin = BottomMenuDialog.dp2px(this.mContext, 10.0f);
        }
        this.rootView.addView((View)childView, (ViewGroup.LayoutParams)params);
        if (hasBottomLine) {
            View line = new View(this.mContext);
            line.setBackgroundColor(-3355444);
            this.rootView.addView(line, -1, 1);
        }
        return childView;
    }

    public void setTextColor(int color) {
        this.textColor = color;
    }

    public StateListDrawable getDrawableListByType(boolean leftTop, boolean rightTop, boolean rightBottom, boolean leftBottom) {
        StateListDrawable stateListDrawable = new StateListDrawable();
        Drawable selectDrawable = this.getWhitShape(5, -3355444, leftTop, rightTop, rightBottom, leftBottom);
        Drawable defaultDrawable = this.getWhitShape(5, -1, leftTop, rightTop, rightBottom, leftBottom);
        stateListDrawable.addState(new int[]{16842919}, selectDrawable);
        stateListDrawable.addState(new int[0], defaultDrawable);
        return stateListDrawable;
    }

    public Drawable getWhitShape(int radius, int bgColor, boolean leftTop, boolean rightTop, boolean rightBottom, boolean leftBottom) {
        float r = BottomMenuDialog.dp2px(this.getContext(), radius);
        float a1 = 0.0f;
        float a2 = 0.0f;
        float a3 = 0.0f;
        float a4 = 0.0f;
        float a5 = 0.0f;
        float a6 = 0.0f;
        float a7 = 0.0f;
        float a8 = 0.0f;
        if (leftTop) {
            a1 = r;
            a2 = r;
        }
        if (rightTop) {
            a3 = r;
            a4 = r;
        }
        if (rightBottom) {
            a5 = r;
            a6 = r;
        }
        if (leftBottom) {
            a7 = r;
            a8 = r;
        }
        float[] outerRadii = new float[]{a1, a2, a3, a4, a5, a6, a7, a8};
        RoundRectShape rrs = new RoundRectShape(outerRadii, null, null);
        ShapeDrawable sd = new ShapeDrawable((Shape)rrs);
        sd.getPaint().setColor(bgColor);
        return sd;
    }

    public void show(FragmentManager manager) {
        if (!this.isAdded()) {
            this.show(manager, TAG);
        }
    }

    public boolean isShowing() {
        return this.dialog != null && this.dialog.isShowing();
    }

    public void close(boolean isAnimation) {
        if (isAnimation) {
            if (this.mBehavior != null) {
                this.mBehavior.setState(5);
            }
        } else {
            this.dismiss();
        }
    }

    public static int dp2px(Context context, float dpVal) {
        return (int)TypedValue.applyDimension((int)1, (float)dpVal, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public void onClick(View v) {
        Object o = v.getTag();
        if (o == null) {
            return;
        }
        String key = String.valueOf(o);
        if (this.listeners.get(key) != null) {
            this.listeners.get(key).onClick(v);
            this.dismiss();
        }
    }

    public static class Builder {
        private ArrayList<String> titles = new ArrayList();
        private Map<String, View.OnClickListener> listeners = new HashMap<String, View.OnClickListener>();

        public BottomMenuDialog build() {
            if (this.titles == null || this.titles.isEmpty()) {
                // empty if block
            }
            return new BottomMenuDialog(this);
        }

        public Builder addItem(String title, View.OnClickListener listener) {
            this.titles.add(title);
            this.listeners.put(String.valueOf(this.titles.size()), listener);
            return this;
        }
    }
}

