/*
 * Decompiled with CFR 0.152.
 */
package com.liji.imagezoom.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.Toast;
import com.liji.imagezoom.R;
import com.liji.imagezoom.util.BottomMenuDialog;
import com.liji.imagezoom.widget.PhotoViewAttacher;
import com.nostra13.universalimageloader.core.ImageLoader;
import com.nostra13.universalimageloader.core.assist.FailReason;
import com.nostra13.universalimageloader.core.listener.ImageLoadingListener;
import com.nostra13.universalimageloader.core.listener.SimpleImageLoadingListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ImageDetailFragment
extends Fragment {
    private String mImageUrl;
    private ImageView mImageView;
    private ProgressBar progressBar;
    private PhotoViewAttacher mAttacher;
    private Bitmap mDownloadImgBitmap = null;
    final int REQUEST_WRITE = 1001;

    public void onDestroy() {
        super.onDestroy();
    }

    public Bitmap getDownloadImgBitmap() {
        return this.mDownloadImgBitmap;
    }

    public void setDownloadImgBitmap(Bitmap downloadImgBitmap) {
        this.mDownloadImgBitmap = downloadImgBitmap;
    }

    public static ImageDetailFragment newInstance(String imageUrl) {
        ImageDetailFragment f = new ImageDetailFragment();
        Bundle args = new Bundle();
        args.putString("url", imageUrl);
        f.setArguments(args);
        return f;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mImageUrl = this.getArguments() != null ? this.getArguments().getString("url") : null;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View v = inflater.inflate(R.layout.fragment_image_detail, container, false);
        this.mImageView = (ImageView)v.findViewById(R.id.image);
        this.mAttacher = new PhotoViewAttacher(this.mImageView);
        this.mAttacher.setOnPhotoTapListener(new PhotoViewAttacher.OnPhotoTapListener(){

            @Override
            public void onPhotoTap(View arg0, float arg1, float arg2) {
                ImageDetailFragment.this.getActivity().finish();
            }
        });
        this.mAttacher.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                BottomMenuDialog dialog = new BottomMenuDialog.Builder().addItem("\u4fdd\u5b58\u5230\u672c\u5730\u76f8\u518c", new View.OnClickListener(){

                    public void onClick(View v) {
                        ImageDetailFragment.this.checkPermission();
                    }
                }).addItem("\u53d6\u6d88", new View.OnClickListener(){

                    public void onClick(View v) {
                        Toast.makeText((Context)ImageDetailFragment.this.getContext(), (CharSequence)"\u53d6\u6d88", (int)1).show();
                    }
                }).build();
                dialog.show(ImageDetailFragment.this.getFragmentManager());
                return true;
            }
        });
        this.progressBar = (ProgressBar)v.findViewById(R.id.loading);
        return v;
    }

    private void checkPermission() {
        if (Build.VERSION.SDK_INT >= 23) {
            if (ContextCompat.checkSelfPermission((Context)this.getContext(), (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
                if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)this.getActivity(), (String)"android.permission.WRITE_EXTERNAL_STORAGE")) {
                    Toast.makeText((Context)this.getActivity(), (CharSequence)"\u4fdd\u5b58\u56fe\u7247\u5230\u672c\u5730\u76f8\u518c\u9700\u8981SD\u5361\u8bfb\u53d6\u6743\u9650\uff0c\u8bf7\u540c\u610f\u8be5\u64cd\u4f5c\uff01", (int)0).show();
                }
                this.requestPermissions(new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, 1001);
            } else {
                this.saveImageToGallery(this.getContext(), this.getDownloadImgBitmap());
            }
        } else {
            this.saveImageToGallery(this.getContext(), this.getDownloadImgBitmap());
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == 1001 && grantResults.length > 0 && grantResults[0] == 0) {
            this.saveImageToGallery(this.getContext(), this.getDownloadImgBitmap());
        } else {
            Toast.makeText((Context)this.getContext(), (CharSequence)"\u83b7\u53d6SD\u5361\u8bfb\u5199\u64cd\u4f5c\u6743\u9650\u5931\u8d25\uff0c\u65e0\u6cd5\u4fdd\u5b58\u7167\u7247\u5230\u672c\u5730", (int)1).show();
        }
    }

    public void saveImageToGallery(Context context, Bitmap bmp) {
        Log.d((String)"ZoomImage", (String)("saveImageToGallery:" + bmp));
        String SAVE_PIC_PATH = Environment.getExternalStorageState().equalsIgnoreCase("mounted") ? Environment.getExternalStorageDirectory().getAbsolutePath() : "/mnt/sdcard";
        File appDir = new File(SAVE_PIC_PATH + "/ZoomImage/");
        if (!appDir.exists()) {
            appDir.mkdir();
        }
        long nowSystemTime = System.currentTimeMillis();
        String fileName = nowSystemTime + ".png";
        File file = new File(appDir, fileName);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(file);
            bmp.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fos);
            fos.flush();
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Uri uri = Uri.fromFile((File)file);
        context.sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", uri));
        Toast.makeText((Context)this.getContext(), (CharSequence)"\u5df2\u4fdd\u5b58\u5230\u672c\u5730\u76f8\u518c", (int)1).show();
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        ImageLoader.getInstance().displayImage(this.mImageUrl, this.mImageView, (ImageLoadingListener)new SimpleImageLoadingListener(){

            public void onLoadingStarted(String imageUri, View view) {
                ImageDetailFragment.this.progressBar.setVisibility(0);
            }

            public void onLoadingFailed(String imageUri, View view, FailReason failReason) {
                String message = null;
                switch (failReason.getType()) {
                    case IO_ERROR: {
                        message = "\u4e0b\u8f7d\u9519\u8bef";
                        break;
                    }
                    case DECODING_ERROR: {
                        message = "\u56fe\u7247\u65e0\u6cd5\u663e\u793a";
                        break;
                    }
                    case NETWORK_DENIED: {
                        message = "\u7f51\u7edc\u6709\u95ee\u9898\uff0c\u65e0\u6cd5\u4e0b\u8f7d";
                        break;
                    }
                    case OUT_OF_MEMORY: {
                        message = "\u56fe\u7247\u592a\u5927\u65e0\u6cd5\u663e\u793a";
                        break;
                    }
                    case UNKNOWN: {
                        message = "\u672a\u77e5\u7684\u9519\u8bef";
                    }
                }
                Toast.makeText((Context)ImageDetailFragment.this.getActivity(), (CharSequence)message, (int)0).show();
                ImageDetailFragment.this.progressBar.setVisibility(8);
            }

            public void onLoadingComplete(String imageUri, View view, Bitmap loadedImage) {
                ImageDetailFragment.this.progressBar.setVisibility(8);
                ImageDetailFragment.this.setDownloadImgBitmap(loadedImage);
                ImageDetailFragment.this.mAttacher.update();
            }
        });
    }
}

