/*
 * Decompiled with CFR 0.152.
 */
package com.liji.imagezoom.activity;

import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentStatePagerAdapter;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.widget.TextView;
import com.liji.imagezoom.R;
import com.liji.imagezoom.activity.ImageDetailFragment;
import com.liji.imagezoom.widget.HackyViewPager;
import java.util.ArrayList;
import java.util.List;

public class ImagePagerActivity
extends FragmentActivity {
    private static final String STATE_POSITION = "STATE_POSITION";
    public static final String EXTRA_IMAGE_INDEX = "image_index";
    public static final String EXTRA_IMAGE_URLS = "image_urls";
    private HackyViewPager mPager;
    private int pagerPosition;
    private TextView indicator;
    private List<String> urlists = new ArrayList<String>();

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.pager_image_detail);
        this.pagerPosition = this.getIntent().getIntExtra(EXTRA_IMAGE_INDEX, 0);
        this.urlists = this.getIntent().getStringArrayListExtra(EXTRA_IMAGE_URLS);
        this.mPager = (HackyViewPager)this.findViewById(R.id.pager);
        ImagePagerAdapter mAdapter = new ImagePagerAdapter(this.getSupportFragmentManager(), this.urlists);
        this.mPager.setAdapter((PagerAdapter)mAdapter);
        this.indicator = (TextView)this.findViewById(R.id.indicator);
        String text = this.getString(R.string.viewpager_indicator, new Object[]{1, this.mPager.getAdapter().getCount()});
        this.indicator.setText((CharSequence)text);
        this.mPager.setOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrollStateChanged(int arg0) {
            }

            public void onPageScrolled(int arg0, float arg1, int arg2) {
            }

            public void onPageSelected(int arg0) {
                String text = ImagePagerActivity.this.getString(R.string.viewpager_indicator, new Object[]{arg0 + 1, ImagePagerActivity.this.mPager.getAdapter().getCount()});
                ImagePagerActivity.this.indicator.setText((CharSequence)text);
            }
        });
        if (savedInstanceState != null) {
            this.pagerPosition = savedInstanceState.getInt(STATE_POSITION);
        }
        this.mPager.setCurrentItem(this.pagerPosition);
    }

    public void onSaveInstanceState(Bundle outState) {
        outState.putInt(STATE_POSITION, this.mPager.getCurrentItem());
    }

    private class ImagePagerAdapter
    extends FragmentStatePagerAdapter {
        public List<String> fileList;

        public ImagePagerAdapter(FragmentManager fm, List<String> fileList) {
            super(fm);
            this.fileList = fileList;
        }

        public int getCount() {
            return this.fileList == null ? 0 : this.fileList.size();
        }

        public Fragment getItem(int position) {
            String url = this.fileList.get(position);
            return ImageDetailFragment.newInstance(url);
        }
    }
}

