/*
 * Decompiled with CFR 0.152.
 */
package com.liji.imagezoom.activity;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.Toast;
import com.liji.imagezoom.R;
import com.liji.imagezoom.widget.PhotoViewAttacher;
import com.nostra13.universalimageloader.core.ImageLoader;
import com.nostra13.universalimageloader.core.assist.FailReason;
import com.nostra13.universalimageloader.core.listener.ImageLoadingListener;
import com.nostra13.universalimageloader.core.listener.SimpleImageLoadingListener;

public class ImageDetailFragment
extends Fragment {
    private String mImageUrl;
    private ImageView mImageView;
    private ProgressBar progressBar;
    private PhotoViewAttacher mAttacher;

    public static ImageDetailFragment newInstance(String imageUrl) {
        ImageDetailFragment f = new ImageDetailFragment();
        Bundle args = new Bundle();
        args.putString("url", imageUrl);
        f.setArguments(args);
        return f;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mImageUrl = this.getArguments() != null ? this.getArguments().getString("url") : null;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View v = inflater.inflate(R.layout.fragment_image_detail, container, false);
        this.mImageView = (ImageView)v.findViewById(R.id.image);
        this.mAttacher = new PhotoViewAttacher(this.mImageView);
        this.mAttacher.setOnPhotoTapListener(new PhotoViewAttacher.OnPhotoTapListener(){

            @Override
            public void onPhotoTap(View arg0, float arg1, float arg2) {
                ImageDetailFragment.this.getActivity().finish();
            }
        });
        this.progressBar = (ProgressBar)v.findViewById(R.id.loading);
        return v;
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        ImageLoader.getInstance().displayImage(this.mImageUrl, this.mImageView, (ImageLoadingListener)new SimpleImageLoadingListener(){

            public void onLoadingStarted(String imageUri, View view) {
                ImageDetailFragment.this.progressBar.setVisibility(0);
            }

            public void onLoadingFailed(String imageUri, View view, FailReason failReason) {
                String message = null;
                switch (failReason.getType()) {
                    case IO_ERROR: {
                        message = "\u4e0b\u8f7d\u9519\u8bef";
                        break;
                    }
                    case DECODING_ERROR: {
                        message = "\u56fe\u7247\u65e0\u6cd5\u663e\u793a";
                        break;
                    }
                    case NETWORK_DENIED: {
                        message = "\u7f51\u7edc\u6709\u95ee\u9898\uff0c\u65e0\u6cd5\u4e0b\u8f7d";
                        break;
                    }
                    case OUT_OF_MEMORY: {
                        message = "\u56fe\u7247\u592a\u5927\u65e0\u6cd5\u663e\u793a";
                        break;
                    }
                    case UNKNOWN: {
                        message = "\u672a\u77e5\u7684\u9519\u8bef";
                    }
                }
                Toast.makeText((Context)ImageDetailFragment.this.getActivity(), (CharSequence)message, (int)0).show();
                ImageDetailFragment.this.progressBar.setVisibility(8);
            }

            public void onLoadingComplete(String imageUri, View view, Bitmap loadedImage) {
                ImageDetailFragment.this.progressBar.setVisibility(8);
                ImageDetailFragment.this.mAttacher.update();
            }
        });
    }
}

