/*
 * Decompiled with CFR 0.152.
 */
package library.neetoffice.com.genericadapter.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import library.neetoffice.com.genericadapter.base.Filter;
import library.neetoffice.com.genericadapter.base.GenericAdapterInterface;

public class ItemManager<E>
implements GenericAdapterInterface<E> {
    public final ArrayList<Integer> indexs = new ArrayList();
    private ArrayList<E> originalItems;
    private Filter<E> filter = new Filter<E>(){

        @Override
        public boolean filter(E item) {
            return true;
        }
    };
    private final Comparator<Integer> indexSort = new Comparator<Integer>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int compare(Integer lhs, Integer rhs) {
            if (ItemManager.this.sort != null) {
                Comparator comparator = ItemManager.this.sort;
                synchronized (comparator) {
                    Object elhs = ItemManager.this.originalItems.get(lhs);
                    Object erhs = ItemManager.this.originalItems.get(rhs);
                    return ItemManager.this.sort.compare(elhs, erhs);
                }
            }
            return lhs - rhs;
        }
    };
    private Comparator<E> sort;
    private boolean enable = true;

    public ItemManager(Collection<E> originalItems) {
        this.originalItems = new ArrayList<E>(originalItems);
        this.refresh();
    }

    public int getItemCount() {
        if (this.isNoData() && this.enable) {
            return 1;
        }
        return this.indexs.size();
    }

    public int getIndexCount() {
        return this.indexs.size();
    }

    @Override
    public boolean isNoData() {
        return this.indexs.isEmpty();
    }

    @Override
    public void setNoDataViewEnable(boolean enable) {
        this.enable = enable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAll(Collection<E> items) {
        try {
            int originalSize = this.originalItems.size();
            boolean bl = this.originalItems.addAll(items);
        }
        catch (Exception exception) {
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    @Override
    public void setAll(Collection<E> items) {
        try {
            this.originalItems.clear();
            this.originalItems.addAll(items);
        }
        catch (Exception exception) {
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    @Override
    public void add(E item) {
        try {
            boolean bl = this.originalItems.add(item);
        }
        catch (Exception exception) {
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, E item) {
        try {
            this.originalItems.add(index, item);
        }
        catch (Exception exception) {
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(int index, E item) {
        try {
            this.originalItems.set(index, item);
        }
        catch (Exception exception) {
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(E item) {
        try {
            Iterator<E> iterator = this.originalItems.iterator();
            while (iterator.hasNext()) {
                E e = iterator.next();
                if (item != e) continue;
                iterator.remove();
                break;
            }
        }
        catch (Exception exception) {
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E remove(int position) {
        block4: {
            E e;
            try {
                if (this.originalItems.size() <= position) break block4;
                E e1 = this.originalItems.get(position);
                Iterator<E> iterator = this.originalItems.iterator();
                while (iterator.hasNext()) {
                    E e2 = iterator.next();
                    if (e1 != e2) continue;
                    iterator.remove();
                    break;
                }
                e = e1;
            }
            catch (Exception exception) {
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            return e;
        }
        return null;
    }

    @Override
    public void clear() {
        this.originalItems.clear();
        this.indexs.clear();
    }

    @Override
    public void setFilter(Filter<E> filter) {
        this.filter = filter;
    }

    @Override
    public void setSort(Comparator<E> sort) {
        this.sort = sort;
    }

    @Override
    public void refresh() {
        this.indexs.clear();
        for (int index = 0; index < this.originalItems.size(); ++index) {
            E originalItem = this.originalItems.get(index);
            if (!this.filter.filter(originalItem) || this.indexs.contains(index)) continue;
            this.indexs.add(index);
        }
        Collections.sort(this.indexs, this.indexSort);
    }

    @Override
    public List<E> getItems() {
        return this.originalItems;
    }

    @Override
    public E getItem(int position) {
        if (this.indexs.size() > position) {
            return this.originalItems.get(this.indexs.get(position));
        }
        return null;
    }
}

