package li.vin.my.apikit.services

import li.vin.my.apikit.api.MapboxPlacesAPI
import li.vin.my.apikit.models.MapboxGeocode
import li.vin.my.apikit.network.BaseService
import li.vin.my.apikit.network.Endpoints

/**
 * 11/17/18.
 */
class MapboxPlacesService(val coordinates: List<Double>, val mapboxToken: String) : BaseService<MapboxGeocode>() {
    override fun createCall() {
        val request = createService(MapboxPlacesAPI::class.java, Endpoints.MAPBOX_URL)
        val coordinateString = coordinates[0].toString() + "," + coordinates[1].toString()
        call = request.geocode(coordinateString, "address,neighborhood,locality,place,region,country", mapboxToken)
    }
}