package li.vin.my.apikit.network

import li.vin.my.apikit.AuthSettings
import okhttp3.Interceptor
import okhttp3.Response
import java.io.IOException
import java.util.*

/**
 * 12/10/18.
 */

class ReceivedCookiesInterceptor : Interceptor {

    @Throws(IOException::class)
    override fun intercept(chain: Interceptor.Chain): Response {
        val originalResponse = chain.proceed(chain.request())

        if (!originalResponse.headers("Set-Cookie").isEmpty()) {
            val cookies = HashSet<String>()
            for (header in originalResponse.headers("Set-Cookie")) {
                AuthSettings.instance.setSessionId(header)
                cookies.add(header)
            }

        }

        return originalResponse
    }
}