package li.vin.my.apikit.models

import com.google.gson.annotations.SerializedName

/**
 * 11/7/18.
 */
data class TripStats(@SerializedName("stats") val stats: TripStatsData?)

data class TripStatsData(
    @SerializedName("maxFuelEconomy") val maxFuelEconomy: Double?,
    @SerializedName("avgFuelEconomy") val avgFuelEconomy: Double?,
    @SerializedName("totalFuelConsumed") val totalFuelConsumed: Double?,
    @SerializedName("totalDistance") val totalDistance: Double?,
    @SerializedName("totalHardAccels") val totalHardAccels: Int?,
    @SerializedName("totalHardBrakes") val totalHardBrakes: Int?,
    @SerializedName("maxTripSpeed") val maxTripSpeed: Double?,
    @SerializedName("avgSpeed") val avgSpeed: Double?,
    @SerializedName("numberOfTrips") val numberOfTrips: Int?
)


/**
{
"stats": {
"maxFuelEconomy": 27.7763,
"avgFuelEconomy": 16.07588222222222,
"totalFuelConsumed": 45.06577,
"totalDistance": 354329.55,
"totalHardAccels": 0,
"totalHardBrakes": 10,
"maxTripSpeed": 61.6327,
"avgSpeed": 34.36053333333332,
"numberOfTrips": 45
}
}
 */