package li.vin.my.apikit.models

import com.google.gson.annotations.SerializedName
import java.util.*

/**
 * 11/5/18.
 */
data class Meta(@SerializedName("pagination") val pagination: Pagination?)

data class Pagination(
    @SerializedName("remaining") val remaining: Int?,
    @SerializedName("until") val until: Date?,
    @SerializedName("since") val since: Date?,
    @SerializedName("limit") val limit: Int?,
    @SerializedName("sortDir") val sortDir: String?,
    @SerializedName("links") val links: Links?,
    @SerializedName("total") val total: Int?
)

data class Links(@SerializedName("prior") val prior: String?)

/**
"meta": {
"pagination": {
"remaining": 8957,
"until": "2015-11-11T01:25:21.777Z",
"since": "1970-01-01T00:00:00.000Z",
"limit": 20,
"sortDir": "desc",
"links": {
"prior": "http://10.100.132.66:39002/api/v1/vehicles/8581410e-142d-4330-aef0-83be0f503b0c/codes?until=1446841927023&since=1970-01-01T00%3A00%3A00.000Z&limit=20&sortDir=desc"
}
}
}
 */