package li.vin.my.apikit.errors

import com.google.gson.annotations.SerializedName
import li.vin.my.apikit.network.Constants

/**
 * 11/1/18.
 */
class GenericError(
    @SerializedName("message")
    var message: String
) {
    companion object {
        fun getErrorMessage(statusCode: Int): String {
            return when (statusCode) {
                ServerErrorCodes.BAD_REQUEST.ordinal -> "Server Error- $statusCode: " + Constants.BAD_REQUEST_MESSAGE
                ServerErrorCodes.FORBIDDEN.ordinal -> "Server Error- $statusCode: " + Constants.FORBIDDEN_MESSAGE
                ServerErrorCodes.NOT_FOUND.ordinal -> "Server Error- $statusCode: " + Constants.NOT_FOUND_MESSAGE
                ServerErrorCodes.SERVICE_UNAVAILABLE.ordinal -> "Server Error- $statusCode: " + Constants.SERVICE_UNAVAILABLE_MESSAGE
                ServerErrorCodes.INTERNAL_ERROR.ordinal -> "Server Error- $statusCode: " + Constants.INTERNAL_ERROR_MESSAGE
                ServerErrorCodes.CONFLICT.ordinal -> "Server Error- $statusCode: " + Constants.CONFLICT_ERROR_MESSAGE
                else -> "Server Error- $statusCode: " + Constants.UNKNOWN_ERROR_MESSAGE
            }
        }
    }
}

data class ErrorMessage(@SerializedName("message") var message: String)