package li.vin.my.apikit.dataformatter

import android.content.Context
import android.util.Log
import android.widget.TextView
import java.util.*


fun String.capitalizeFirstLetter(): String {
    return this.substring(0, 1).toUpperCase(Locale.getDefault()) + this.substring(1).toLowerCase(Locale.getDefault())
}

fun Int.capitalizeFirstLetter(context: Context): String {
    val value = context.resources.getString(this)
    return value.substring(0, 1).toUpperCase(Locale.getDefault()) + value.substring(1).toLowerCase(Locale.getDefault())
}

fun String.capitalizeAll(): String {
    return this.toUpperCase(Locale.getDefault())
}

fun Int.capitalizeAll(context: Context): String {
    val value = context.resources.getString(this)
    return value.toUpperCase(Locale.getDefault())
}

fun String.lowerCaseAll(): String {
    return this.toLowerCase(Locale.getDefault())
}

fun Int.lowerCaseAll(context: Context): String {
    val value = context.resources.getString(this)
    return value.toLowerCase(Locale.getDefault())
}

fun String.capitalizeFirstLetterAllWords(): String {
    return capitalizeFirstLetterAllWordsFunction(this)
}

fun Int.capitalizeFirstLetterAllWords(context: Context): String {
    val value = context.resources.getString(this)
    return capitalizeFirstLetterAllWordsFunction(value)
}

private fun capitalizeFirstLetterAllWordsFunction(value: String): String {
    val strArray = value.split(" ")
    val builder = StringBuilder()
    for ((count, s) in strArray.withIndex()) {
        try {
        val cap = s.substring(0, 1).toUpperCase(Locale.getDefault()) + s.substring(1)
            if (count != strArray.size - 1) {
                builder.append(cap + " ")
            } else {
                builder.append(cap)
            }
        } catch(e: Exception) {
            Log.d("<><>", "String error: " + value + "  exception: " + e.localizedMessage)
        }
    }
    return builder.toString()
}

fun TextView.styleMarkdownTextView(text: Int) {
    this.setText(this.resources.getString(text), TextView.BufferType.SPANNABLE)
    MarkDownUtil.setMarkdownText(this)
}

fun TextView.styleMarkdownTextView(text: String) {
    this.setText(text, TextView.BufferType.SPANNABLE)
    MarkDownUtil.setMarkdownText(this)
}

