package li.vin.my.apikit.dataformatter

import android.graphics.Typeface
import android.text.Spannable
import android.text.SpannableString
import android.text.style.RelativeSizeSpan
import android.text.style.StyleSpan
import android.text.style.TypefaceSpan
import android.widget.TextView

object MarkDownUtil {
    fun setMarkdownText(textView: TextView) {
        changeLineInViewTitleStyle(textView, "# ", 2f) // Primary Header
        changeLineInView(textView, "\n# ", 1.5f) // Secondary Header
        changeLineInView(textView, "\n## ", 1.2f) // Secondary Header
        changeLineInView(textView, "\n---", 1.2f) // Horizontal Rule
        changeLineInView(textView, "\n>", 0.9f) // Block Quotes
        changeLineInView(textView, "\n - ", 1f)   // Classic Markdown List
        changeLineInView(textView, "\n- ", 1f)   // NonStandard List

        spanSetterInView(textView, "\n```\n", "\n```\n", Typeface.BOLD, "monospace", 0.8f, false) // fenced code Blocks ( endAtLineBreak=false since this is a multiline block operator)
        spanSetterInView(textView, " **", "** ", Typeface.BOLD, "", 1f, true) // Bold
//    spanSetterInView(textView, " *", "* ", Typeface.ITALIC, "", 1f, true) // Italic
        spanSetterInView(textView, " ***", "*** ", Typeface.BOLD_ITALIC, "", 1f, true) // Bold and Italic
        spanSetterInView(textView, " `", "` ", Typeface.BOLD, "monospace", 0.8f, true) // inline code
        spanSetterInView(textView, "\n    ", "\n", Typeface.BOLD, "monospace", 0.7f, true) // classic indented code
    }
}

private fun changeLineInView(tv: TextView, target: String, size: Float) {
    val vString = tv.text.toString()
    var startSpan: Int
    var endSpan = 0
    val spanRange = tv.text as Spannable
    while (true) {
        startSpan = vString.indexOf(target, endSpan - 1)
        endSpan = vString.indexOf("\n", startSpan + 1)
        if (startSpan < 0 || endSpan < 0) break
        if (endSpan > startSpan) {
            spanRange.setSpan(RelativeSizeSpan(size), startSpan, endSpan, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE)
            spanRange.setSpan(StyleSpan(Typeface.BOLD), startSpan, endSpan, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE)
        }
    }
    tv.text = spanRange
}

private fun changeLineInViewTitleStyle(tv: TextView, target: String, size: Float) {
    val vString = tv.text.toString()
    var endSpan = 0
    val spanRange = tv.text as Spannable
    val startSpan = vString.substring(0, target.length).indexOf(target, endSpan - 1)
    endSpan = vString.indexOf("\n", startSpan + 1)
    if (startSpan >= 0) {
        if (endSpan > startSpan) {
            spanRange.setSpan(RelativeSizeSpan(size), startSpan, endSpan, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE)
            spanRange.setSpan(StyleSpan(Typeface.BOLD_ITALIC), startSpan, endSpan, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE)
        }
    }
    tv.text = spanRange
}

private fun spanSetterInView(tv: TextView, startTarget: String, endTarget: String, typefaceStyle: Int, fontFamily: String, size: Float, endAtLineBreak: Boolean) {
    var vString = tv.text.toString()
    if (vString.toCharArray().get(vString.length - 1) == endTarget.toCharArray().get(0)) {
        vString = vString + " "
    }
    var startSpan = ArrayList<Int>()
    var endSpan = ArrayList<Int>()
    var spanRange: Spannable? = null
    var currentCount = 0
    while (true) {
        startSpan.add(vString.indexOf(startTarget) + 1)
        endSpan.add(vString.indexOf(endTarget) - startTarget.length - 1)
        if (!endAtLineBreak) {
            val endSpan_linebreak = vString.indexOf("\n", startSpan[currentCount] + 1 + startTarget.length)
            if (endSpan_linebreak < endSpan[currentCount]) {
                endSpan[currentCount] = endSpan_linebreak
            }
        }
        if (startSpan[currentCount] < 0 || endSpan[currentCount] < 0) break
        endSpan[currentCount] += endTarget.length
        if (endSpan[currentCount] > startSpan[currentCount]) {
            val newString = StringBuilder(vString)
            for (i in 0..startTarget.length - 2) {
                newString.setCharAt(startSpan[currentCount] + i, '∂')
            }
            for (i in 0..endTarget.length - 2) {
                newString.setCharAt(endSpan[currentCount] + i + 1, '∂')
            }
            val editedString = newString.toString().replace("∂", "")
            spanRange = SpannableString(editedString)
            for (i in 0..currentCount) {
                spanRange.setSpan(RelativeSizeSpan(size), startSpan[i], endSpan[i], Spannable.SPAN_EXCLUSIVE_EXCLUSIVE)
                spanRange.setSpan(StyleSpan(typefaceStyle), startSpan[i], endSpan[i], Spannable.SPAN_EXCLUSIVE_EXCLUSIVE)
                if (fontFamily != "") spanRange.setSpan(TypefaceSpan(fontFamily), startSpan[i], endSpan[i], Spannable.SPAN_EXCLUSIVE_EXCLUSIVE)
            }
        }

        if (spanRange!!.contains(startTarget)) {
            vString = spanRange.toString()
            currentCount++
        } else {
            break
        }
    }
    if (spanRange != null) {
        tv.text = spanRange
    }
}