package li.vin.my.apikit.api

import li.vin.my.apikit.models.CreateTagsData
import li.vin.my.apikit.models.TagPostBody
import li.vin.my.apikit.models.TagsPostBody
import li.vin.my.apikit.models.UpdateTagData
import retrofit2.Call
import retrofit2.http.*

/**
 * 12/18/18.
 */
interface TagAPI {

    @PUT("/api/v1/trips/{tripId}/tags/{tagId}")
    fun updateTag(
        @Path("tagId") tagId: String,
        @Path("tripId") tripId: String,
        @Body body: TagPostBody,
        @Header("Authorization") auth: String
    ): Call<UpdateTagData>


    @POST("/api/v1/trips/{tripId}/tags")
    fun createTag(
        @Path("tripId") tripId: String,
        @Body body: TagsPostBody,
        @Header("Authorization") auth: String
    ): Call<CreateTagsData>
}