package li.vin.my.apikit.dataformatter

import li.vin.my.apikit.dataformatter.Constants.DASH
import java.text.DateFormat
import java.text.SimpleDateFormat
import java.util.*
import java.util.concurrent.TimeUnit

// January 1, 2019
fun Date?.formatLongDate(): String {
    try {
        this?.let {
            val locale = Locale.getDefault()
            return DateFormat.getDateInstance(DateFormat.LONG, locale).format(it)
        }
        return DASH
    } catch (e: Exception) {
        return DASH
    }
}

// Jan1, 2019
fun Date?.formatMediumDate(): String {
    try {
        this?.let {
            val locale = Locale.getDefault()
            return DateFormat.getDateInstance(DateFormat.MEDIUM, locale).format(it)
        }
        return DASH
    } catch (e: Exception) {
        return DASH
    }
}

fun Date?.getDateMinuteInterval(): Boolean {
    try {
        this?.let {
            val currentDate = Date()
            val interval = currentDate.time - it.time
            return (TimeUnit.MILLISECONDS.toSeconds(interval) < 60.0)
        }
    } catch (e: Exception) {
        return false
    }
    return false
}

// January 1, 2019 12:00AM
fun Date?.formatDateTime(): String {
    try {
        this?.let {
            val locale = Locale.getDefault()
            return DateFormat.getDateTimeInstance(DateFormat.LONG, DateFormat.SHORT, locale)
                .format(it)
        }
        return DASH
    } catch (e: Exception) {
        return DASH
    }
}

// 2019
fun Date?.formatYear(): String {
    try {
        this?.let {
            val locale = Locale.getDefault()
            val format = SimpleDateFormat("yyyy", locale)
            return format.format(it)
        }
        return DASH
    } catch (e: Exception) {
        return DASH
    }
}

// Jan 1, 2019 12:00 AM
fun Date?.formatMediumDateTime(): String {
    try {
        this?.let {
            val locale = Locale.getDefault()
            return DateFormat.getDateTimeInstance(DateFormat.MEDIUM, DateFormat.SHORT, locale)
                .format(it)
        }
        return DASH
    } catch (e: Exception) {
        return DASH
    }
}

//Monday, January 1, 2019
fun Date?.formatDayDate(): String {
    try {
        this?.let {
            val locale = Locale.getDefault()
            val format = SimpleDateFormat("EEEE", locale)
            return format.format(this) + ", " + DateFormat.getDateInstance(
                DateFormat.MEDIUM,
                locale
            ).format(it)
        }
        return DASH
    } catch (e: Exception) {
        return DASH
    }
}

// Monday
fun Date?.formatDay(): String {
    try {
        this?.let {
            val locale = Locale.getDefault()
            val format = SimpleDateFormat("EEEE", locale)
            return format.format(this)
        }
        return DASH
    } catch (e: Exception) {
        return DASH
    }
}

// Jan 1, 2019
fun Long?.formatMediumDate(): String {
    try {
        this?.let {
            val locale = Locale.getDefault()
            val calendar = Calendar.getInstance()
            calendar.timeInMillis = it
            return DateFormat.getDateInstance(DateFormat.MEDIUM, locale).format(calendar.time)
        }
        return DASH
    } catch (e: Exception) {
        return DASH
    }
}

// 12:00 AM
fun Date?.formatTime(): String {
    try {
        this?.let {
            val locale = Locale.getDefault()
            return DateFormat.getTimeInstance(DateFormat.SHORT, locale).format(it)
        }
        return DASH
    } catch (e: Exception) {
        return DASH
    }
}

fun Date?.formatTimeSpanString(yesterday: String, day2: String, day3: String, day4: String, day5: String, day6: String): String {
    try {
        this?.let {
            val value: String
            if (Calendar.getInstance().time.time - it.time <= 604800000) {
                val fmt = SimpleDateFormat("yyyyMMdd")
                val diff = Calendar.getInstance().time.day - it.day
                if (fmt.format(Calendar.getInstance().time) == fmt.format(it)) {
                    val locale = Locale.getDefault()
                    value = DateFormat.getTimeInstance(DateFormat.SHORT, locale).format(it)
                } else {
                    val time = if (diff > 0) diff else diff + 7
                    when (time) {
                        1 -> value = yesterday
                        2 -> value = day2
                        3 -> value = day3
                        4 -> value = day4
                        5 -> value = day5
                        6 -> value = day6
                        else -> {
                            val locale = Locale.getDefault()
                            value = DateFormat.getDateTimeInstance(DateFormat.MEDIUM, DateFormat.SHORT, locale).format(it)
                        }
                    }
                }
            } else {
                val locale = Locale.getDefault()
                value = DateFormat.getDateTimeInstance(DateFormat.MEDIUM, DateFormat.SHORT, locale).format(it)
            }
            return value
        }
        return DASH
    } catch (e: Exception) {
        return DASH
    }
}

// 1 hr 47 min
fun Long?.formatTimeInHoursAndMinutes(isRTL: Boolean, minute: String, hour: String): String {
    try {
        this?.let {
            if (TimeUnit.MILLISECONDS.toHours(it) != 0L) {
                if (isRTL) {
                    return String.format("%s %d %s %d",
                        minute,
                        TimeUnit.MILLISECONDS.toMinutes(it) -
                                TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(it)),
                        hour,
                        TimeUnit.MILLISECONDS.toHours(it))
                } else {
                    return String.format("%d %s %d %s",
                        TimeUnit.MILLISECONDS.toHours(it),
                        hour,
                        TimeUnit.MILLISECONDS.toMinutes(it) -
                                TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(it)),
                        minute)
                }
            } else {
                if (isRTL) {
                    return String.format("%s %d",
                        minute,
                        TimeUnit.MILLISECONDS.toMinutes(it) -
                                TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(it)))
                } else {
                    return String.format("%d %s",
                        TimeUnit.MILLISECONDS.toMinutes(it) -
                                TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(it)),
                        minute)
                }
            }
        }
        return DASH
    } catch (e: Exception) {
        return DASH
    }
}

// 33 min 26 sec
fun Long?.formatTimeInHoursAndMinutesAndSeconds(isRTL: Boolean, second: String, minute: String, hour: String): String {
    try {
        this?.let {
            if (TimeUnit.MILLISECONDS.toHours(it) != 0L) {
                if (isRTL) {
                    return String.format("%s %2d %s %2d",
                        minute,
                        TimeUnit.MILLISECONDS.toMinutes(it) -
                                TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(it)),
                       hour,
                        TimeUnit.MILLISECONDS.toHours(it))
                } else {
                    return String.format("%1d %s %2d %s",
                        TimeUnit.MILLISECONDS.toHours(it),
                        hour,
                        TimeUnit.MILLISECONDS.toMinutes(it) -
                                TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(it)),
                        minute)
                }
            } else {
                if (isRTL) {
                    return String.format("%s %2d %s %2d",
                        second,
                        TimeUnit.MILLISECONDS.toSeconds(it) -
                                TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(it)),
                        minute,
                        TimeUnit.MILLISECONDS.toMinutes(it) -
                                TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(it)))
                } else {
                    return String.format("%1d %s %2d %s",
                        TimeUnit.MILLISECONDS.toMinutes(it) -
                                TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(it)),
                        minute,
                        TimeUnit.MILLISECONDS.toSeconds(it) -
                                TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(it)),
                        second)
                }
            }
        }
        return DASH
    } catch (e: Exception) {
        return DASH
    }
}

// 33:26
fun Long?.formatTimeForTimer(isRTL: Boolean): String {
    try {
        this?.let {
            if (TimeUnit.MILLISECONDS.toHours(it) != 0L) {
                if (isRTL) {
                    return String.format("%02d:%02d:%02d",
                        TimeUnit.MILLISECONDS.toSeconds(it) -
                                TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(it)),
                        TimeUnit.MILLISECONDS.toMinutes(it) -
                                TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(it)),
                        TimeUnit.MILLISECONDS.toHours(it))
                } else {
                    return String.format("%02d:%02d:%02d",
                        TimeUnit.MILLISECONDS.toHours(it),
                        TimeUnit.MILLISECONDS.toMinutes(it) -
                                TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(it)),
                        TimeUnit.MILLISECONDS.toSeconds(it) -
                                TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(it)))
                }
            } else {
                if (isRTL) {
                    return String.format("%02d:%02d",
                        TimeUnit.MILLISECONDS.toSeconds(it) -
                                TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(it)),
                        TimeUnit.MILLISECONDS.toMinutes(it) -
                                TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(it)))
                } else {
                    return String.format("%02d:%02d",
                        TimeUnit.MILLISECONDS.toMinutes(it) -
                                TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(it)),
                        TimeUnit.MILLISECONDS.toSeconds(it) -
                                TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(it)))
                }
            }
        }
        return DASH
    } catch (e: Exception) {
        return DASH
    }
}