package li.vin.my.apikit.services

import android.text.TextUtils
import li.vin.my.apikit.api.TelemetryAPI
import li.vin.my.apikit.models.Telemetry
import li.vin.my.apikit.network.BaseService
import li.vin.my.apikit.network.Endpoints

/**
 * 5/19/20.
 */
class TelemetryService(val fields: List<String>?, val limit: Int) : BaseService<Telemetry>() {
    override fun createCall() {
        if (fields != null && fields.isNotEmpty()) {
            val request = createService(TelemetryAPI::class.java, Endpoints.getTelemetrySnapshotUrl())
            call = request.getTelemetry(getDriverId(), getVehicleId(), TextUtils.join(",", fields), limit, getAuthToken())
        }
    }
}