package li.vin.my.apikit.models

import com.google.gson.annotations.SerializedName
import java.util.*

/**
 * 1/4/19.
 */
data class TelemetryLocations(
    @SerializedName("locations") val locations: Locations?,
    @SerializedName("meta") val meta: Meta?
)

data class Locations(
    @SerializedName("type") val type: String?,
    @SerializedName("features") val features: List<LocationFeatures>?
)

data class LocationFeatures(
    @SerializedName("type") val type: String?,
    @SerializedName("geometry") val geometry: FeatureGeometry?,
    @SerializedName("properties") val properties: FeatureProperties?
)

data class FeatureGeometry(
    @SerializedName("type") val type: String?,
    @SerializedName("coordinates") val coordinates: List<Double>?
)

data class FeatureProperties(
    @SerializedName("id") val id: String?,
    @SerializedName("timestamp") val timestamp: Date?,
    @SerializedName("links") val links: FeatureLinks?
)

data class FeatureLinks(@SerializedName("self") val self: String?)

/**
{
"locations": {
"type": "FeatureCollection",
"features": [
{
"type": "Feature",
"geometry": {
"type": "Point",
"coordinates": [
-96.7898,
32.782112
]
},
"properties": {
"id": "b0c35090-b4a7-40e8-971b-b8572a504162",
"timestamp": "2019-01-04T14:34:59.000Z",
"data": {},
"links": {
"self": "https://telemetry.vin.li/api/v1/messages/b0c35090-b4a7-40e8-971b-b8572a504162"
}
}
},
{
"type": "Feature",
"geometry": {
"type": "Point",
"coordinates": [
-96.789799,
32.782109
]
},
"properties": {
"id": "dd296e9c-4b74-42ec-8973-27d5f1a7cac7",
"timestamp": "2019-01-04T14:34:51.000Z",
"data": {},
"links": {
"self": "https://telemetry.vin.li/api/v1/messages/dd296e9c-4b74-42ec-8973-27d5f1a7cac7"
}
}
}
]
},
"meta": {
"pagination": {
"remaining": 85283,
"until": "2019-01-04T16:52:39.120Z",
"since": "1970-01-01T00:00:00.000Z",
"limit": 20,
"sortDir": "desc",
"links": {
"prior": "https://telemetry.vin.li/api/v1/devices/dfa40a89-e383-4974-b363-0bf0ca1ab17b/locations?until=1546612346999"
}
}
}
}
 */