package li.vin.my.apikit.models

import com.google.gson.annotations.SerializedName
import java.util.*

data class Events(@SerializedName("events") val events: List<EventsData>?,
                  @SerializedName("meta") val meta: Meta?)

data class SingleEvent(@SerializedName("event") val event: EventsData?)

data class EventsData(@SerializedName("id") val id: String?,
                      @SerializedName("timestamp") val timestamp: Date?,
                      @SerializedName("deviceId") val deviceId: String?,
                      @SerializedName("vehicleId") val vehicleId: String?,
                      @SerializedName("eventType") val eventType: EventType?,
                      @SerializedName("object") val eventObject: EventDataObject?,
                      @SerializedName("location") val location: EventsLocationObject?,
                      @SerializedName("meta") val meta: EventsDataMeta?,
                      @SerializedName("links") val links: EventDataLinks?,
                      @SerializedName("stored") val stored: Date?,
                      @SerializedName("storageLatency") val storageLatency: Int?)

data class EventDataObject(@SerializedName("id") val id: String?,
                           @SerializedName("type") val type: String?,
                           @SerializedName("appId") val appId: String?)

data class EventsLocationObject(@SerializedName("type") val type: String?,
                                @SerializedName("coordinates") val coordinates: List<Double>?)

data class EventDataLinks(@SerializedName("self") val self: String?,
                          @SerializedName("notifications") val notifications: String?,
                          @SerializedName("events") val events: String?,
                          @SerializedName("subscriptions") val subscriptions: String?)

data class EventsDataMeta(@SerializedName("vehicleId") val vehicleId: String?,
                          @SerializedName("code") val code: String?,
                          @SerializedName("direction") val direction: String?,
                          @SerializedName("firstEval") val firstEval: Boolean?,
                          @SerializedName("rule") val rule: EventsDataMetaRule?,
                          @SerializedName("message") val message: EventsDataMetaMessage?,
                          @SerializedName("duration") val duration: Long?,
                          @SerializedName("obdIdleTotTime") val obdIdleTotTime: Int?,
                          @SerializedName("maxRoadSpeed") val maxRoadSpeed: Double?,
                          @SerializedName("maxAccleration") val maxAccleration: Double?,
                          @SerializedName("maxVehicleSpeed") val maxVehicleSpeed: Double?,
                          @SerializedName("messages") val messages: List<EventsMessages>?,
                          @SerializedName("maxValue") val maxValue: Double?,
                          @SerializedName("threshold") val threshold: Double?,
                          @SerializedName("minRoadSpeed") val minRoadSpeed: Double?,
                          @SerializedName("largestDeltaMessage") val largestDeltaMessage: EventsMessages?,
                          @SerializedName("minVehicleSpeed") val minVehicleSpeed: Double?)

data class EventsMessages(@SerializedName("roadSpeed") val roadSpeed: Double?,
                          @SerializedName("vehicleSpeed") val vehicleSpeed: Double?,
                          @SerializedName("message") val message: EventSpeedMessage?)

data class EventSpeedMessage(@SerializedName("location") val location: List<Double>?,
                             @SerializedName("messageId") val messageId: String?,
                             @SerializedName("timestamp") val timestamp: Date?)

data class EventsDataMetaRule(@SerializedName("id") val id: String?,
                              @SerializedName("name") val name: String?,
                              @SerializedName("deviceId") val deviceId: String?,
                              @SerializedName("appId") val appId: String?,
                              @SerializedName("duration") val duration: Long?,
                              @SerializedName("object") val ruleObject: EventDataObject?,
                              @SerializedName("boundaries") val boundaries: List<EventsDataMetaBoundaries>?,
                              @SerializedName("evaluated") val evaluated: Boolean?,
                              @SerializedName("covered") val covered: Boolean?,
                              @SerializedName("createdAt") val createdAt: Date?,
                              @SerializedName("links") val links: EventDataLinks?)

data class EventsDataMetaBoundaries(@SerializedName("id") val id: String?,
                                    @SerializedName("type") val type: String?,
                                    @SerializedName("radius") val radius: Double?,
                                    @SerializedName("lon") val lon: Double?,
                                    @SerializedName("lat") val lat: Double?,
                                    @SerializedName("parameter") val parameter: String?,
                                    @SerializedName("max") val max: Int?,
                                    @SerializedName("min") val min: Int?,
                                    @SerializedName("coordinates")val coordinates: List<List<List<Double>>>?)

data class EventsDataMetaMessage(@SerializedName("id") val id: String?,
                                 @SerializedName("timestamp") val timestamp: Date?,
                                 @SerializedName("snapshot") val snapshot: EventsDataMetaMessageSnapshot?)

data class EventsDataMetaMessageSnapshot(@SerializedName("location") val location: SnapshotLocation?,
                                         @SerializedName("accel") val accel: SnapshotEvent?,
                                         @SerializedName("rpm") val rpm: Double?,
                                         @SerializedName("calculatedLoadValue") val calculatedLoadValue: Double?,
                                         @SerializedName("designOBDRequirements") val designOBDRequirements: String?,
                                         @SerializedName("vehicleSpeed") val vehicleSpeed: Int?,
                                         @SerializedName("intakeManifoldPressure") val intakeManifoldPressure: Int?,
                                         @SerializedName("massAirFlow") val massAirFlow: Double?,
                                         @SerializedName("fuelLevelInput") val fuelLevelInput: Double?)

data class SnapshotLocation(@SerializedName("lat") val lat: Double?,
                            @SerializedName("lon") val lon: Double?)

data class SnapshotEvent(@SerializedName("maxZ") val maxZ: Double?,
                         @SerializedName("maxX") val maxX: Double?,
                         @SerializedName("maxY") val maxY: Double?,
                         @SerializedName("minX") val minX: Double?,
                         @SerializedName("minY") val minY: Double?,
                         @SerializedName("minZ") val minZ: Double?)