package li.vin.my.apikit.models

import java.util.*

/**
 * 1/14/19.
 */
enum class EventType constructor(val value: String) {

    STARTUP("startup"),
    SHUTDOWN("shutdown"),
    RULE_ENTER("rule-enter"),
    RULE_LEAVE("rule-leave"),
    DTC_ON("dtc-on"),
    DTC_OFF("dtc-off"),
    COLLISION("collision"),
    TRIP_STARTED("trip-started"),
    TRIP_ORPHANED("trip-orphaned"),
    TRIP_STOPPED("trip-stopped"),
    TRIP_COMPLETED("trip-completed"),
    DISTANCE_TRIGGER("distance-trigger"),
    COMM_DISRUPTED("comm-disrupted"),
    DEVICE_CLAIMED("device-claimed"),
    PHONE_HOME("phone-home"),
    PLUGGED_IN("plugged-in"),
    RULE("rule-*"),
    TRIP("trip-*"),
    VEHICLE_CHANGED("vehicle-changed"),
    HARD_ACCEL("hard-accel"),
    HARD_DECEL("hard-decel"),
    HARD_TURN("hard-turn"),
    BATTERY("battery-level"),
    SPEEDING("high-speed"),
    IDLING("idling"),
    OVER_REVVING("over-revving"),
    OTHER("");

    companion object {

        private val map = HashMap<String, EventType>()

        init {
            for (unitType in values()) {
                map[unitType.value] = unitType
            }
        }

        fun unitTypeByValue(value: String): EventType {
            return map[value]!!
        }
    }
}