package li.vin.my.apikit.services

import li.vin.my.apikit.api.TagAPI
import li.vin.my.apikit.models.CreateTagsData
import li.vin.my.apikit.models.TagsPostBody
import li.vin.my.apikit.network.BaseService
import li.vin.my.apikit.network.Endpoints

/**
 * 12/4/18.
 */
class TripsTagCreateService(val tripId: String, val body: TagsPostBody) : BaseService<CreateTagsData>() {

    override fun createCall() {
        val request = createService(TagAPI::class.java, Endpoints.getVinliBaseUrl())
        call = request.createTag(tripId, body, getAuthToken())
    }
}