package li.vin.my.apikit.models

import java.util.*

enum class TelemetryType constructor(val value: String) {
    FUEL("fuelLevelInput"),
    BATTERY("batteryVoltage");

    companion object {

        private val map = HashMap<String, TelemetryType>()

        init {
            for (unitType in values()) {
                map[unitType.value] = unitType
            }
        }

        fun unitTypeByValue(value: String): TelemetryType {
            return map[value]!!
        }
    }
}