package li.vin.my.apikit.models

import com.google.gson.annotations.SerializedName
import java.util.*

/**
 * 11/5/18.
 */
data class Telemetry(
    @SerializedName("snapshots") val snapshots: List<TelemetrySnapShots>?,
    @SerializedName("meta") val meta: Meta?
)

data class TelemetrySnapShots(
    @SerializedName("id") val id: String?,
    @SerializedName("timestamp") val timestamp: Date?,
    @SerializedName("data") val data: TelemetrySnapshotData?,
    @SerializedName("links") val links: TelemetrySnapshotLinks?
)

// As we use telemetry, add the fields here for the data
data class TelemetrySnapshotData(
    @SerializedName("fuelLevelInput") val fuelLevelInput: Double?,
    @SerializedName("vehicleSpeed") val vehicleSpeed: Int?,
    @SerializedName("calculatedLoadValue") val calculatedLoadValue: Double?,
    @SerializedName("rpm") val rpm: Int?,
    @SerializedName("batteryVoltage") val batteryVoltage: Double?
)

data class TelemetrySnapshotLinks(@SerializedName("self") val self: String?)

fun Double?.getBatteryStatusColor(): BatteryColor {
    if (this != null) {
        if (this > 11.75) {
            return BatteryColor.GREEN
        } else if (this > 11.31) {
            return BatteryColor.YELLOW
        } else {
            return BatteryColor.RED
        }
    }
    return BatteryColor.UNKNOWN
}

/**
{
"snapshots": [
{
"id": "ac10cb1f-b1c3-462e-9bb8-f618bec90f1b",
"timestamp": "2018-11-05T14:40:07.000Z",
"data": {
"fuelLevelInput": 19.2,
"vehicleSpeed": 12,
"rpm": 850
},
"links": {
"self": "https://telemetry.vin.li/api/v1/messages/ac10cb1f-b1c3-462e-9bb8-f618bec90f1b"
}
}
],
"meta": {
"pagination": {
"remaining": 1,
"until": "2018-11-05T21:10:24.317Z",
"since": "1970-01-01T00:00:00.000Z",
"limit": 1,
"sortDir": "desc",
"links": {
"prior": "https://telemetry.vin.li/api/v1/devices/dfa40a89-e383-4974-b363-0bf0ca1ab17b/snapshots?fields=fuelLevelInput&limit=1&until=1541428806999"
}
}
}
}
 */