package li.vin.my.apikit.models

import com.google.gson.annotations.SerializedName

data class ContactsWrapper(@SerializedName("contacts") val contacts: List<Contact>?)

data class ContactWrapper(@SerializedName("contact") var contact: Contact?)

data class Contact(
    @SerializedName("id") val id: String?,
    @SerializedName("deviceId") val deviceId: String?,
    @SerializedName("name") val name: String?,
    @SerializedName("phoneNumber") val phoneNumber: String?,
    @SerializedName("contactType") val contactType: String?,
    @SerializedName("connectNumber") val connectNumber: String?,
    @SerializedName("connectNumberSecondary") val connectNumberSecondary: String?,
    @SerializedName("message") val message: String?,
    @SerializedName("priority") val priority: Int?,
    @SerializedName("createdAt") val createdAt: String?,
    @SerializedName("updatedAt") val updatedAt: String?,
    @SerializedName("links") val links: LinksContact?
)

data class LinksContact(
    @SerializedName("self") val self: String?,
    @SerializedName("device") val device: String?
)


/**
{
"contacts": [{
"id": "8f417772-8281-4969-b233-592ad3b05c22",
"name": "voldemort",
"phoneNumber": "+15125555555",
"contactType": "sms",
"connectNumber": null,
"connectNumberSecondary": null,
"message": "The one who shall not be named The one who shall not be named\nThe one who shall not be named",
"priority": 9,
"createdAt": "2018-11-27T03:57:31.641Z",
"updatedAt": "2018-11-27T18:48:47.122Z",
"links": {
"self": "https://safety.vin.li/api/v1/_internal/emergency_contacts/8f417772-8281-4969-b233-592ad3b05c22",
"device": "https://platform.vin.li/api/v1/_internal/devices/dfa40a89-e383-4974-b363-0bf0ca1ab17b"
}
}]
}

 */
