package li.vin.my.apikit.api

import li.vin.my.apikit.models.Trips
import li.vin.my.apikit.models.TripsData
import retrofit2.Call
import retrofit2.http.GET
import retrofit2.http.Header
import retrofit2.http.Path
import retrofit2.http.Query

/**
 * 11/7/18.
 */
interface TripsAPI {

    @GET("/api/v1/devices/{deviceId}/trips")
    fun getTripsDeprecated(
        @Path("deviceId") deviceId: String,
        @Query("since") since: String,
        @Query("limit") limit: Long,
        @Query("until") until: String,
        @Query("sortDir") sort: String,
        @Header("Cookie") sessionCookie: String
    ): Call<Trips>

    @GET("/api/v1/drivers/{driverId}/trips")
    fun getTrips(
        @Path("driverId") driverId: String,
        @Query("since") since: String,
        @Query("limit") limit: Long,
        @Query("until") until: String,
        @Query("sortDir") sort: String,
        @Header("Cookie") sessionCookie: String
    ): Call<Trips>

    @GET("/api/v3/trips/{tripId}/playback")
    fun getV3TripPlayBack(
        @Path("tripId") tripId: String,
        @Header("Authorization") auth: String
    ): Call<TripsData>

    @GET("/api/v3/trips/{tripId}/playback")
    fun getV3TripPlayBack(
        @Path("tripId") tripId: String,
        @Query("since") since: Long,
        @Header("Authorization") auth: String
    ): Call<TripsData>
}