package li.vin.my.apikit.models

import com.google.gson.annotations.SerializedName
import java.util.*

data class LatestLocation(
    @SerializedName("type") val type: String?,
    @SerializedName("geometry") val geometry: Geometry?,
    @SerializedName("properties") val properties: Properties?
)

data class Geometry(
    @SerializedName("type") val type: String?,
    @SerializedName("coordinates") val coordinates: DoubleArray?
)

data class Properties(
    @SerializedName("id") val type: String?,
    @SerializedName("timestamp") val timestamp: Date?,
    @SerializedName("links") val links: LinksLocation?
)

data class LinksLocation(
    @SerializedName("self") val self: String?
)

data class LatestLocationsWrapper(@SerializedName("locations") var locations: LatestLocationsFeatures?)

data class LatestLocationsFeatures(@SerializedName("features") var features: List<LatestLocation>?,
                                    @SerializedName("type") val type: String?)

data class TelemetryLocationsWrapper(@SerializedName("locations") var locations: LocationsFeaturesWrapper? = null)

data class LocationsFeaturesWrapper(@SerializedName("features") var features: List<LatestLocation>? = null)

/*
"latestLocation": {
  "type": "Feature",
  "geometry": {
    "type": "Point",
    "coordinates": [
      -96.791244,
      32.781101
    ]
  },
  "properties": {
    "id": "a7788e1a-3eb1-437f-b25e-4d56c952c9f7",
    "timestamp": "2015-09-24T13:43:02.857Z",
    "data": {},
    "links": {
      "self": "http://10.100.36.23:30009/api/v1/messages/a7788e1a-3eb1-437f-b25e-4d56c952c9f7"
    }
  }
}
*/


