package li.vin.my.apikit.models

import com.google.gson.annotations.SerializedName

data class PremiumService(
    @SerializedName("id") val id: String?,
    @SerializedName("name") val name: String?,
    @SerializedName("iconUrl") val iconUrl: String?,
    @SerializedName("description") val description: String?,
    @SerializedName("cost") val cost: Float?,
    @SerializedName("denomination") val denomination: String?,
    @SerializedName("costRecurrance") val costRecurrance: String?,
    @SerializedName("subscription") val subscription: String?,
    @SerializedName("features") val features: List<Features>?,
    @SerializedName("serviceLevel") val serviceLevel: String?,
    @SerializedName("createdAt") val createdAt: String?
)

data class Features(
    @SerializedName("id") val id: String?,
    @SerializedName("desc") val desc: String?,
    @SerializedName("basic") val basic: Boolean?,
    @SerializedName("premium") val premium: Boolean?
)

data class PremiumServicesWrapper(
    @SerializedName("services") var services: List<PremiumService>?
)

/*
{
"services": [
{
  "id": "f4c9b8b3-a486-465a-8596-7ec075f1ff80",
  "name": "My Service Shop",
  "iconUrl": "https://s3.amazonaws.com/vinli-public/app-catalog/shop/my-shop-icon.png",
  "description": "Never forget a maintenance milestone again. Your friendly neighborhood mechanic is a click away.",
  "cost": 2999,
  "denomination": "USD",
  "costRecurrance": "year",
  "subscription": null,
  "features": [
    {
      "id": "1",
      "desc": "See your vehicle's diagnostics",
      "basic": true,
      "premium": true
    },
    {
      "id": "2",
      "desc": "See nearby mechanics",
      "basic": true,
      "premium": true
    },
    {
      "id": "3",
      "desc": "Schedule maintenance at your mechanic",
      "basic": false,
      "premium": true
    }
  ],
  "serviceLevel": null,
  "createdAt": "2015-08-18T20:47:27.370Z"
},
{
  "id": "92972842-6e46-4c02-958c-aad717da0306",
  "name": "Roadside Assistance",
  "iconUrl": "https://s3.amazonaws.com/vinli-public/app-catalog/roadside/roadside-assistance.png",
  "description": "Flat tire? Dead battery? Just need directions? Vinli will be there to help get you on your way.",
  "cost": 2999,
  "denomination": "USD",
  "costRecurrance": "year",
  "subscription": null,
  "features": [
    {
      "id": "1",
      "desc": "See nearby RSA providers",
      "basic": true,
      "premium": true
    },
    {
      "id": "2",
      "desc": "See your vehicle's exact location",
      "basic": true,
      "premium": true
    },
    {
      "id": "3",
      "desc": "One Click request Roadside Assistance",
      "basic": false,
      "premium": true
    }
  ],
  "serviceLevel": null,
  "createdAt": "2015-08-18T20:47:27.369Z"
},
{
  "id": "95068696-edbe-47b9-8131-7501aedb7fe5",
  "name": "E-Call",
  "iconUrl": "https://s3.amazonaws.com/vinli-public/app-catalog/ecall/ecall-icon.png",
  "description": "Automatic text or voice notification to your loved ones when you're involved in a collision.",
  "cost": 2999,
  "denomination": "USD",
  "costRecurrance": "year",
  "subscription": null,
  "features": [
    {
      "id": "1",
      "desc": "Send SMS messages if a collision occurs",
      "basic": true,
      "premium": true
    },
    {
      "id": "2",
      "desc": "Send Voice messages if a collision occurs",
      "basic": true,
      "premium": true
    },
    {
      "id": "3",
      "desc": "Call 911 if a collision occurs",
      "basic": false,
      "premium": true
    }
  ],
  "serviceLevel": null,
  "createdAt": "2015-08-18T20:47:27.367Z"
}
]
}
*/

//    class PremiumServicesWrapper : Wrappers.PageWrapper<PremiumService>, Serializable {
//        var services: List<PremiumService>? = null
//
//        fun getPremiumServices(): List<PremiumService> {
//            return services!!
//        }
//
//        override fun unwrapPage(): List<PremiumService> {
//            return getPremiumServices()
//        }
//    }


