package li.vin.my.apikit

import android.content.Context
import android.util.Log
import com.google.gson.Gson
import java.io.*
import java.lang.reflect.Type
import java.nio.charset.Charset
import java.util.*

/**
 * 12/9/18.
 */

class ArchiveDAO<T>(
    private val context: Context,
    private val persistentType: Type,
    private val persistentPath: String
) {

    private val gson = Gson()

    fun create(id: String, entity: T): Boolean {
        var writer: BufferedWriter? = null
        try {
            val dataFile = File(context.filesDir, persistentPath + "/" + id)
            dataFile.parentFile.mkdirs()

            writer = BufferedWriter(OutputStreamWriter(FileOutputStream(dataFile), Charset.defaultCharset()))
            gson.toJson(entity, writer)
        } catch (e: NullPointerException) {
            Log.d("<><>", e.message)
            return false
        } catch (e: IOException) {
            Log.d("<><>", e.message)
            return false
        } finally {
            if (writer != null) {
                try {
                    writer.close()
                } catch (e: IOException) {
                    // nobody cares
                }

            }
        }
        return true
    }

    fun read(id: String): T? {
        var input: BufferedReader? = null
        try {
            val dataFile = File(context.filesDir, persistentPath + "/" + id)
            input = BufferedReader(InputStreamReader(FileInputStream(dataFile), Charset.defaultCharset()))
            try {
                return gson.fromJson<T>(input, persistentType)
            } finally {
                input.close()
            }
        } catch (e: NullPointerException) {
            Log.d("<><>", e.message)
        } catch (e: IOException) {
            Log.d("<><>", e.message)
        } catch (e: Exception) {
            Log.d("<><>", e.message)
        } finally {
            if (input != null) {
                try {
                    input.close()
                } catch (e: IOException) {
                    Log.d("<><>", e.message)
                }

            }
        }
        return null
    }

    fun delete(id: String): Boolean {
        try {
            val targetFile = File(context.filesDir, persistentPath + "/" + id)
            return targetFile.delete()
        } catch (e: NullPointerException) {
            Log.d("<><>", e.message)
            return false
        }

    }

    fun update(id: String, entity: T): Boolean {
        delete(id)
        return create(id, entity)
    }

    fun findAll(): List<T> {
        val entityList = ArrayList<T>()
        try {
            val parentDirectory = File(context.filesDir, persistentPath)

            val fileList = parentDirectory.listFiles()

            for (file in fileList) {
                if (file.isFile) {
                    val entity = read(file.name)
                    entityList.add(entity!!)
                }
            }
        } catch (e: NullPointerException) {
            Log.d("<><>", e.message)
        }

        return entityList
    }
}
