/*
 * Decompiled with CFR 0.152.
 */
package li.vin.my.apikit;

import android.app.Application;
import android.content.Context;
import io.sentry.Sentry;
import io.sentry.SentryClientFactory;
import io.sentry.android.AndroidSentryClientFactory;
import java.io.File;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import li.vin.my.apikit.AuthSettings;
import li.vin.my.apikit.network.ReceivedCookiesInterceptor;
import okhttp3.Cache;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B'\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lli/vin/my/apikit/ApiKit;", "", "context", "Landroid/content/Context;", "baseUrl", "", "cacheDir", "Ljava/io/File;", "appName", "(Landroid/content/Context;Ljava/lang/String;Ljava/io/File;Ljava/lang/String;)V", "getAppName", "()Ljava/lang/String;", "getBaseUrl", "getCacheDir", "()Ljava/io/File;", "getContext", "()Landroid/content/Context;", "Companion", "apikit_release"})
public final class ApiKit {
    @NotNull
    private final Context context;
    @NotNull
    private final String baseUrl;
    @NotNull
    private final File cacheDir;
    @NotNull
    private final String appName;
    private static ApiKit apikit;
    @NotNull
    private static final OkHttpClient.Builder okHttpClientBuilder;
    @NotNull
    public static OkHttpClient okHttpClient;
    private static boolean debugLogging;
    private static boolean allowRefresh;
    public static final Companion Companion;

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final String getBaseUrl() {
        return this.baseUrl;
    }

    @NotNull
    public final File getCacheDir() {
        return this.cacheDir;
    }

    @NotNull
    public final String getAppName() {
        return this.appName;
    }

    private ApiKit(Context context, String baseUrl, File cacheDir, String appName) {
        this.context = context;
        this.baseUrl = baseUrl;
        this.cacheDir = cacheDir;
        this.appName = appName;
    }

    static {
        Companion = new Companion(null);
        okHttpClientBuilder = new OkHttpClient.Builder();
    }

    public /* synthetic */ ApiKit(Context context, String baseUrl, File cacheDir, String appName, DefaultConstructorMarker $constructor_marker) {
        this(context, baseUrl, cacheDir, appName);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u001e\u0010\u000f\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001cJ\u0016\u0010\u000f\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001cJ&\u0010\u000f\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001cJ&\u0010\u000f\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u001cJ\u001e\u0010\u000f\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u001cJ \u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001cH\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u0006\"\u0004\b\r\u0010\bR\u0011\u0010\u000e\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006'"}, d2={"Lli/vin/my/apikit/ApiKit$Companion;", "", "()V", "allowRefresh", "", "getAllowRefresh", "()Z", "setAllowRefresh", "(Z)V", "apikit", "Lli/vin/my/apikit/ApiKit;", "debugLogging", "getDebugLogging", "setDebugLogging", "instance", "getInstance", "()Lli/vin/my/apikit/ApiKit;", "okHttpClient", "Lokhttp3/OkHttpClient;", "getOkHttpClient", "()Lokhttp3/OkHttpClient;", "setOkHttpClient", "(Lokhttp3/OkHttpClient;)V", "okHttpClientBuilder", "Lokhttp3/OkHttpClient$Builder;", "getOkHttpClientBuilder", "()Lokhttp3/OkHttpClient$Builder;", "getAuthToken", "", "application", "Landroid/app/Application;", "cacheDir", "Ljava/io/File;", "appName", "baseUrl", "initializeOkHttp", "", "context", "Landroid/content/Context;", "apikit_release"})
    public static final class Companion {
        @NotNull
        public final OkHttpClient.Builder getOkHttpClientBuilder() {
            return okHttpClientBuilder;
        }

        @NotNull
        public final OkHttpClient getOkHttpClient() {
            OkHttpClient okHttpClient = okHttpClient;
            if (okHttpClient == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"okHttpClient");
            }
            return okHttpClient;
        }

        public final void setOkHttpClient(@NotNull OkHttpClient okHttpClient) {
            Intrinsics.checkParameterIsNotNull((Object)okHttpClient, (String)"<set-?>");
            ApiKit.okHttpClient = okHttpClient;
        }

        public final boolean getDebugLogging() {
            return debugLogging;
        }

        public final void setDebugLogging(boolean bl) {
            debugLogging = bl;
        }

        public final boolean getAllowRefresh() {
            return allowRefresh;
        }

        public final void setAllowRefresh(boolean bl) {
            allowRefresh = bl;
        }

        @NotNull
        public final ApiKit getInstance(@NotNull Application application, @NotNull String appName) {
            Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
            Intrinsics.checkParameterIsNotNull((Object)appName, (String)"appName");
            if (apikit == null) {
                Context context = application.getApplicationContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"application.applicationContext");
                Context context2 = application.getApplicationContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"application.applicationContext");
                File file = context2.getCacheDir();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"application.applicationContext.cacheDir");
                apikit = new ApiKit(context, "vin.li", file, appName, null);
                Context context3 = application.getApplicationContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context3, (String)"application.applicationContext");
                this.initializeOkHttp(context3, application, appName);
            }
            ApiKit apiKit = apikit;
            if (apiKit == null) {
                Intrinsics.throwNpe();
            }
            return apiKit;
        }

        @NotNull
        public final ApiKit getInstance(@NotNull Application application, @NotNull String baseUrl, @NotNull String appName) {
            Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
            Intrinsics.checkParameterIsNotNull((Object)baseUrl, (String)"baseUrl");
            Intrinsics.checkParameterIsNotNull((Object)appName, (String)"appName");
            if (apikit == null) {
                Context context = application.getApplicationContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"application.applicationContext");
                Context context2 = application.getApplicationContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"application.applicationContext");
                File file = context2.getCacheDir();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"application.applicationContext.cacheDir");
                apikit = new ApiKit(context, baseUrl, file, appName, null);
                Context context3 = application.getApplicationContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context3, (String)"application.applicationContext");
                this.initializeOkHttp(context3, application, appName);
            }
            ApiKit apiKit = apikit;
            if (apiKit == null) {
                Intrinsics.throwNpe();
            }
            return apiKit;
        }

        @NotNull
        public final ApiKit getInstance(@NotNull Application application, @NotNull String baseUrl, boolean debugLogging, @NotNull String appName) {
            Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
            Intrinsics.checkParameterIsNotNull((Object)baseUrl, (String)"baseUrl");
            Intrinsics.checkParameterIsNotNull((Object)appName, (String)"appName");
            if (apikit == null) {
                Context context = application.getApplicationContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"application.applicationContext");
                Context context2 = application.getApplicationContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"application.applicationContext");
                File file = context2.getCacheDir();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"application.applicationContext.cacheDir");
                apikit = new ApiKit(context, baseUrl, file, appName, null);
                this.setDebugLogging(debugLogging);
                Context context3 = application.getApplicationContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context3, (String)"application.applicationContext");
                this.initializeOkHttp(context3, application, appName);
            }
            ApiKit apiKit = apikit;
            if (apiKit == null) {
                Intrinsics.throwNpe();
            }
            return apiKit;
        }

        @NotNull
        public final ApiKit getInstance(@NotNull Application application, @NotNull String baseUrl, @NotNull File cacheDir, @NotNull String appName) {
            Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
            Intrinsics.checkParameterIsNotNull((Object)baseUrl, (String)"baseUrl");
            Intrinsics.checkParameterIsNotNull((Object)cacheDir, (String)"cacheDir");
            Intrinsics.checkParameterIsNotNull((Object)appName, (String)"appName");
            if (apikit == null) {
                Context context = application.getApplicationContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"application.applicationContext");
                apikit = new ApiKit(context, baseUrl, cacheDir, appName, null);
                Context context2 = application.getApplicationContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"application.applicationContext");
                this.initializeOkHttp(context2, application, appName);
            }
            ApiKit apiKit = apikit;
            if (apiKit == null) {
                Intrinsics.throwNpe();
            }
            return apiKit;
        }

        @NotNull
        public final ApiKit getInstance(@NotNull Application application, @NotNull File cacheDir, @NotNull String appName) {
            Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
            Intrinsics.checkParameterIsNotNull((Object)cacheDir, (String)"cacheDir");
            Intrinsics.checkParameterIsNotNull((Object)appName, (String)"appName");
            if (apikit == null) {
                Context context = application.getApplicationContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"application.applicationContext");
                apikit = new ApiKit(context, "vin.li", cacheDir, appName, null);
                Context context2 = application.getApplicationContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"application.applicationContext");
                this.initializeOkHttp(context2, application, appName);
            }
            ApiKit apiKit = apikit;
            if (apiKit == null) {
                Intrinsics.throwNpe();
            }
            return apiKit;
        }

        private final String getAuthToken() {
            return AuthSettings.Companion.getInstance().getAuthToken();
        }

        private final void initializeOkHttp(Context context, Application application, String appName) {
            Sentry.init((String)"https://74084de8fefb43b7803ab4a5b55474bb@sentry.io/1935791", (SentryClientFactory)((SentryClientFactory)new AndroidSentryClientFactory(application)));
            AuthSettings.Companion.getInstance(context, appName);
            long cacheSize = 0xA00000L;
            Cache cacheDir = new Cache(this.getInstance().getCacheDir(), cacheSize);
            this.getOkHttpClientBuilder().cache(cacheDir);
            HttpLoggingInterceptor logging = new HttpLoggingInterceptor(null, 1, null);
            logging.level(this.getDebugLogging() ? HttpLoggingInterceptor.Level.BODY : HttpLoggingInterceptor.Level.BASIC);
            this.getOkHttpClientBuilder().addInterceptor((Interceptor)logging);
            this.getOkHttpClientBuilder().addInterceptor((Interceptor)new ReceivedCookiesInterceptor());
            if (Intrinsics.areEqual((Object)AuthSettings.Companion.getInstance().getAuthToken(), (Object)"Bearer") ^ true) {
                Interceptor.Companion companion = Interceptor.Companion;
                OkHttpClient.Builder builder = this.getOkHttpClientBuilder();
                boolean $i$f$invoke = false;
                Interceptor interceptor = new Interceptor(){

                    @NotNull
                    public Response intercept(@NotNull Interceptor.Chain chain) {
                        Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
                        Interceptor.Chain chain2 = chain;
                        boolean bl = false;
                        Request original = chain2.request();
                        Request.Builder requestBuilder = original.newBuilder().header("Authorization", li.vin.my.apikit.ApiKit$Companion.access$getAuthToken(ApiKit.Companion)).method(original.method(), original.body());
                        Request request = requestBuilder.build();
                        return chain2.proceed(request);
                    }
                };
                builder.addInterceptor(interceptor);
            }
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            TrustManagerFactory trustManagerFactory2 = trustManagerFactory;
            Intrinsics.checkExpressionValueIsNotNull((Object)trustManagerFactory2, (String)"trustManagerFactory");
            Object[] trustManagers = trustManagerFactory2.getTrustManagers();
            boolean bl = trustManagers.length == 1 && trustManagers[0] instanceof X509TrustManager;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Unexpected default trust managers:" + Arrays.toString(trustManagers);
                throw (Throwable)new IllegalStateException(string.toString());
            }
            TrustManager trustManager = trustManagers[0];
            if (trustManager == null) {
                throw new TypeCastException("null cannot be cast to non-null type javax.net.ssl.X509TrustManager");
            }
            X509TrustManager trustManager2 = (X509TrustManager)trustManager;
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{trustManager2}, null);
            OkHttpClient.Builder builder = this.getOkHttpClientBuilder();
            SSLContext sSLContext = sslContext;
            Intrinsics.checkExpressionValueIsNotNull((Object)sSLContext, (String)"sslContext");
            SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
            Intrinsics.checkExpressionValueIsNotNull((Object)sSLSocketFactory, (String)"sslContext.socketFactory");
            builder.sslSocketFactory(sSLSocketFactory, trustManager2);
            this.getOkHttpClientBuilder().connectTimeout(45L, TimeUnit.SECONDS);
            this.getOkHttpClientBuilder().readTimeout(45L, TimeUnit.SECONDS);
            this.setOkHttpClient(this.getOkHttpClientBuilder().build());
        }

        @NotNull
        public final ApiKit getInstance() {
            if (apikit == null) {
                throw (Throwable)new IllegalStateException("Apikit context not set");
            }
            ApiKit apiKit = apikit;
            if (apiKit == null) {
                Intrinsics.throwNpe();
            }
            return apiKit;
        }

        private Companion() {
        }

        public static final /* synthetic */ String access$getAuthToken(Companion $this) {
            return $this.getAuthToken();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

