package li.vin.my.apikit.services

import li.vin.my.apikit.api.UserAPI
import li.vin.my.apikit.models.*
import li.vin.my.apikit.network.BaseService
import li.vin.my.apikit.network.Endpoints

/**
 * 12/26/18.
 */
class UserUpdateService(
    private val email: String?,
    private val firstName: String?,
    private val lastName: String?,
    private val phone: String?,
    private val isMetric: Boolean? = true,
    private val country: String?,
    private val locale: String?
) : BaseService<User>() {

    override fun createCall() {
        val request = createService(UserAPI::class.java, Endpoints.getAuthBaseUrl())
        val unit = if (isMetric != null && isMetric) MeasureType.METRIC else MeasureType.IMPERIAL
        val userData = UserPostData(email, firstName, lastName, null, phone, UserPostSettings(unit.value, country, locale))
        val session = UserPost(userData)
        call = request.updateUser(session, getCookies(), getAuthToken())
    }
}