package li.vin.my.apikit.dataformatter

import li.vin.my.apikit.dataformatter.Constants.DASH
import li.vin.my.apikit.dataformatter.Constants.GALLON_US_TO_GALLON_UK
import li.vin.my.apikit.dataformatter.Constants.KILOMETERS_TO_MILES
import li.vin.my.apikit.dataformatter.Constants.LITERS_TO_GALLONS_US
import li.vin.my.apikit.dataformatter.Constants.M_TO_KM
import li.vin.my.apikit.dataformatter.Constants.M_TO_MILES
import java.text.DecimalFormat
import java.text.NumberFormat
import java.util.*

fun Double?.formattedPercentageDataPoint(): String {
    try {
        this?.let {
            val locale = Locale.getDefault()
            val newValue = it / 100.0
            return NumberFormat.getPercentInstance(locale).format(newValue)
        }
        return DASH
    } catch (e: Exception) {
        return DASH
    }
}

fun Int?.formattedPercentageDataPoint(): String {
    try {
        this?.let {
            val locale = Locale.getDefault()
            val newValue = it / 100.0
            return NumberFormat.getPercentInstance(locale).format(newValue)
        }
        return DASH
    } catch (e: Exception) {
        return DASH
    }
}

fun Double?.parseDistanceDataToMeters(isMetric: Boolean): Double {
    try {
        this?.let {
            if (isMetric) {
                return it / M_TO_KM
            } else {
                return it / M_TO_MILES
            }
        }
        return 0.0
    } catch (e: Exception) {
        return 0.0
    }
}

// 0.2 MILES
fun Double?.formatDistanceFromMetersWithUnitRounded(isMetric: Boolean, isRTL: Boolean, metricUnit: String, imperialUnit: String): String {
    try {
        this?.let {
            val locale = Locale.getDefault()
            if (isMetric) {
                if (isRTL) {
                    return String.format(locale, "%s %d", metricUnit.capitalizeAll(), Math.round(it * M_TO_KM).toInt())
                } else {
                    return String.format(locale, "%d %s", Math.round(it * M_TO_KM).toInt(), metricUnit.capitalizeAll())
                }
            } else {
                if (isRTL) {
                    return String.format(locale, "%s %d", imperialUnit.capitalizeFirstLetter(), Math.round(it * M_TO_MILES).toInt())
                } else {
                    return String.format(locale, "%d %s", Math.round(it * M_TO_MILES).toInt(), imperialUnit.capitalizeAll())
                }
            }
        }
        return DASH
    } catch (e: Exception) {
        return DASH
    }
}

// 0.2 MILES
fun Double?.formatDistanceFromMetersWithUnit(isMetric: Boolean, isRTL: Boolean, metricUnit: String, imperialUnit: String): String {
    try {
        this?.let {
            val locale = Locale.getDefault()
            if (isMetric) {
                if (it * M_TO_KM > 999.9) {
                    if (isRTL) {
                        return String.format(locale, "%s %.1fk", metricUnit.capitalizeAll(), (it * M_TO_KM) / 1000.0)
                    } else {
                        return String.format(locale, "%.1fk %s", (it * M_TO_KM) / 1000.0, metricUnit.capitalizeAll())
                    }
                } else {
                    if (isRTL) {
                        return String.format(locale, "%s %.1f", metricUnit.capitalizeAll(), it * M_TO_KM)
                    } else {
                        return String.format(locale, "%.1f %s", it * M_TO_KM, metricUnit.capitalizeAll())
                    }
                }
            } else {
                if (it * M_TO_MILES > 999.9) {
                    if (isRTL) {
                        return String.format(locale, "%s %.1fk", imperialUnit.capitalizeFirstLetter(), (it * M_TO_MILES) / 1000.0)
                    } else {
                        return String.format(locale, "%.1fk %s", (it * M_TO_MILES) / 1000.0, imperialUnit.capitalizeAll())
                    }
                } else {
                    if (isRTL) {
                        return String.format(locale, "%s %.1f", imperialUnit.capitalizeFirstLetter(), it * M_TO_MILES)
                    } else {
                        return String.format(locale, "%.1f %s", it * M_TO_MILES, imperialUnit.capitalizeAll())
                    }
                }
            }
        }
        return DASH
    } catch (e: Exception) {
        return DASH
    }
}

// 0.2 mi
fun Double?.formatDistanceFromMetersWithUnitAbbreviated(isMetric: Boolean, isRTL: Boolean, metricUnit: String, imperialUnit: String): String {
    try {
        this?.let {
            val locale = Locale.getDefault()
            if (isMetric) {
                if (it * M_TO_KM > 999.9) {
                    if (isRTL) {
                        return String.format(locale, "%s %.1fk", metricUnit, (it * M_TO_KM) / 1000.0)
                    } else {
                        return String.format(locale, "%.1fk %s", (it * M_TO_KM) / 1000.0, metricUnit)
                    }
                } else {
                    if (isRTL) {
                        return String.format(locale, "%s %.1f", metricUnit, it * M_TO_KM)
                    } else {
                        return String.format(locale, "%.1f %s", it * M_TO_KM, metricUnit)
                    }
                }
            } else {
                if (it * M_TO_MILES > 999.9) {
                    if (isRTL) {
                        return String.format(locale, "%s %.1fk", imperialUnit, (it * M_TO_MILES) / 1000.0)
                    } else {
                        return String.format(locale, "%.1fk %s", (it * M_TO_MILES / 1000.0), imperialUnit)
                    }
                } else {
                    if (isRTL) {
                        return String.format(locale, "%s %.1f", imperialUnit, it * M_TO_MILES)
                    } else {
                        return String.format(locale, "%.1f %s", it * M_TO_MILES, imperialUnit)
                    }
                }
            }
        }
        return DASH
    } catch (e: Exception) {
        return DASH
    }
}

// 0.2
fun Double?.formatDistanceFromMeters(isMetric: Boolean): String {
    try {
        this?.let {
            val locale = Locale.getDefault()
            if (isMetric) {
                if (it * M_TO_KM > 9999.9) {
                    return String.format(locale, "%.1fk", (it * M_TO_KM) / 1000.0)
                } else {
                    return String.format(locale, "%.1f", it * M_TO_KM)
                }
            } else {
                if (it * M_TO_MILES > 9999.9) {
                    return String.format(locale, "%.1fk", (it * M_TO_MILES) / 1000.0)
                } else {
                    return String.format(locale, "%.1f", it * M_TO_MILES)
                }
            }
        }
        return DASH
    } catch (e: Exception) {
        return DASH
    }
}

// 0.20 KM
fun Double?.formatDistanceFromMetersWithUnitAndTwoDecimals(isMetric: Boolean, isRTL: Boolean, metricUnit: String, imperialUnit: String): String {
    try {
        this?.let {
            val locale = Locale.getDefault()
            if (isMetric) {
                if (it * M_TO_KM > 999.9) {
                    if (isRTL) {
                        return String.format(locale, "%s %.2fk", metricUnit.capitalizeAll(), (it * M_TO_KM) / 1000.0)
                    } else {
                        return String.format(locale, "%.2fk %s", (it * M_TO_KM) / 1000.0, metricUnit.capitalizeAll())
                    }
                } else {
                    if (isRTL) {
                        return String.format(locale, "%s %.2f", metricUnit.capitalizeAll(), it * M_TO_KM)
                    } else {
                        return String.format(locale, "%.2f %s", it * M_TO_KM, metricUnit.capitalizeAll())
                    }
                }
            } else {
                if (it * M_TO_MILES > 999.9) {
                    if (isRTL) {
                        return String.format(locale, "%s %.2fk", imperialUnit.capitalizeFirstLetter(), (it * M_TO_MILES) / 1000.0)
                    } else {
                        return String.format(locale, "%.2fk %s", (it * M_TO_MILES) / 1000.0, imperialUnit.capitalizeAll())
                    }
                } else {
                    if (isRTL) {
                        return String.format(locale, "%s %.2f", imperialUnit.capitalizeFirstLetter(), it * M_TO_MILES)
                    } else {
                        return String.format(locale, "%.2f %s", it * M_TO_MILES, imperialUnit.capitalizeAll())
                    }
                }
            }
        }
        return DASH
    } catch (e: Exception) {
        return DASH
    }
}

// 20.0
fun Double?.formatDistanceFromMetersWithoutK(isMetric: Boolean): String {
    try {
        this?.let {
            val locale = Locale.getDefault()
            if (isMetric) {
                if (it * M_TO_KM > 9999.9) {
                    val formatter = DecimalFormat("###,###")
                    return formatter.format(it * M_TO_KM)
                } else {
                    return String.format(locale, "%.1f", it * M_TO_KM)
                }
            } else {
                if (it * M_TO_MILES > 9999.9) {
                    val formatter = DecimalFormat("###,###")
                    return formatter.format(it * M_TO_MILES)
                } else {
                    return String.format(locale, "%.1f", it * M_TO_MILES)
                }
            }
        }
        return DASH
    } catch (e: Exception) {
        return DASH
    }
}

// 20.0006
fun Double?.formatDistanceFromMetersToDouble(isMetric: Boolean): Double {
    try {
        this?.let {
            if (isMetric) {
                return it * M_TO_KM
            } else {
                return it * M_TO_MILES
            }
        }
        return 0.0
    } catch (e: Exception) {
        return 0.0
    }
}

// 124.6 mph
fun Double?.formatSpeedFromKilometersAnHour(isMetric: Boolean, isRTL: Boolean, metricUnit: String, imperialUnit: String): String {
    try {
        this?.let {
            val locale = Locale.getDefault()
            if (isMetric) {
                if (isRTL) {
                    return String.format(locale, "%s %.1f", metricUnit, it)
                } else {
                    return String.format(locale, "%.1f %s", it, metricUnit)
                }
            } else {
                if (isRTL) {
                    return String.format(locale, "%s %.1f", imperialUnit, it / Constants.KPH_TO_MPH)
                } else {
                    return String.format(locale, "%.1f %s", it / Constants.KPH_TO_MPH, imperialUnit)
                }
            }
        }
        return DASH
    } catch (e: Exception) {
        return DASH
    }
}

// 125 mph
fun Double?.formatSpeedFromKilometersAnHourNoDecimal(isMetric: Boolean, isRTL: Boolean, metricUnit: String, imperialUnit: String): String {
    try {
        this?.let {
            val locale = Locale.getDefault()
            if (isMetric) {
                if (isRTL) {
                    return String.format(locale, "%s %.0f", metricUnit, it)
                } else {
                    return String.format(locale, "%.0f %s", it, metricUnit)
                }
            } else {
                if (isRTL) {
                    return String.format(locale, "%s %.0f", imperialUnit, it / Constants.KPH_TO_MPH)
                } else {
                    return String.format(locale, "%.0f %s", it / Constants.KPH_TO_MPH, imperialUnit)
                }
            }
        }
        return DASH
    } catch (e: Exception) {
        return DASH
    }
}

// 200.6 kph/s
fun Double?.formatSpeedFromKilometersAnHourPerSecondNoDecimal(isMetric: Boolean, isRTL: Boolean, metricUnit: String, imperialUnit: String): String {
    try {
        this?.let {
            val locale = Locale.getDefault()
            if (isMetric) {
                if (isRTL) {
                    return String.format(locale, "%s %.1f", metricUnit, it)
                } else {
                    return String.format(locale, "%.1f %s", it, metricUnit)
                }
            } else {
                if (isRTL) {
                    return String.format(locale, "%s %.1f", imperialUnit, it / Constants.KPH_TO_MPH)
                } else {
                    return String.format(locale, "%.1f %s", it / Constants.KPH_TO_MPH, imperialUnit)
                }
            }
        }
        return DASH
    } catch (e: Exception) {
        return DASH
    }
}

// 200.6
fun Double?.formatSpeedFromKilometersAnHourWithoutUnit(isMetric: Boolean): Double {
    try {
        this?.let {
            if (isMetric) {
                return it
            } else {
                return it / Constants.KPH_TO_MPH
            }
        }
        return 0.0
    } catch (e: Exception) {
        return 0.0
    }
}

// 200.6 L
fun Double?.formatFuelUsedFromLiters(isMetric: Boolean, isRTL: Boolean, metricUnit: String, imperialUnit: String): String {
    try {
        this?.let {
            val locale = Locale.getDefault()
            if (isMetric) {
                if (isRTL) {
                    return String.format(locale, "%s %.2f", metricUnit.capitalizeAll(), it)
                } else {
                    return String.format(locale, "%.2f %s", it, metricUnit.capitalizeAll())
                }
            } else {
                if (isRTL) {
                    return String.format(locale, "%s %.2f", imperialUnit, it * Constants.LITERS_TO_GALLONS)
                } else {
                    return String.format(locale, "%.2f %s", it * Constants.LITERS_TO_GALLONS, imperialUnit)
                }
            }
        }
        return DASH
    } catch (e: Exception) {
        return DASH
    }
}

// 200.6
fun Double?.formatFuelUsedFromLitersWithoutUnit(isMetric: Boolean): Double {
    try {
        this?.let {
            if (isMetric) {
                return it
            } else {
                return it * Constants.LITERS_TO_GALLONS
            }
        }
        return 0.0
    } catch (e: Exception) {
        return 0.0
    }
}

// 1.2 L/100 km    240.9 mpg
fun Double?.formatFuelRangeFromMPG(isMetric: Boolean, isRTL: Boolean, metricUnit: String, imperialUnit: String): String {
    try {
        this?.let {
            val locale = Locale.getDefault()
            if (isMetric) {
                val value = 100.0f * KILOMETERS_TO_MILES / (LITERS_TO_GALLONS_US * it)
                if (isRTL) {
                    return String.format(locale, "%s %.1f", metricUnit, value)
                } else {
                    return String.format(locale, "%.1f %s", value, metricUnit)
                }
            } else {
                val convertedMpg = it / GALLON_US_TO_GALLON_UK
                if (isRTL) {
                    return String.format(locale, "%s %.1f", imperialUnit, convertedMpg)
                } else {
                    return String.format(locale, "%.1f %s", convertedMpg, imperialUnit)
                }
            }
        }
        return DASH
    } catch (e: Exception) {
        return DASH
    }
}

// 240.91060080950885
fun Double?.formatFuelRangeFromMPG(isMetric: Boolean): Double {
    try {
        this?.let {
            if (isMetric) {
                return 100.0f * KILOMETERS_TO_MILES / (LITERS_TO_GALLONS_US * it)
            } else {
                return it / GALLON_US_TO_GALLON_UK
            }
        }
        return 0.0
    } catch (e: Exception) {
        return 0.0
    }
}
