package li.vin.my.apikit.services

import android.graphics.Bitmap
import li.vin.my.apikit.api.DeviceAPI
import li.vin.my.apikit.models.Device
import li.vin.my.apikit.network.BaseService
import li.vin.my.apikit.network.Endpoints
import li.vin.my.apikit.network.getImageString

/**
 * 1/9/19.
 */
class CreateDeviceService(val name: String?, val icon: Bitmap?, val caseId: String) : BaseService<Device>() {

    override fun createCall() {
        val request = createService(DeviceAPI::class.java, Endpoints.getAuthBaseUrl())
        call = request.createDevice(
            name
                ?: caseId, getImageString(icon), caseId, getAuthToken()
        )
    }
}