package li.vin.my.apikit.api

import li.vin.my.apikit.models.Password
import li.vin.my.apikit.models.User
import li.vin.my.apikit.models.UserPost
import retrofit2.Call
import retrofit2.http.Body
import retrofit2.http.Header
import retrofit2.http.POST
import retrofit2.http.PUT

/**
 * 12/10/18.
 */
interface UserAPI {

    @POST("/api/v1/users")
    fun createUser(@Body user: UserPost): Call<User>

    @PUT("/api/v1/users/_current")
    fun updateUser(
        @Body user: UserPost,
        @Header("Authorization") bearerToken: String
    ): Call<User>

    @POST("/api/v1/users/_current/changePassword")
    fun updatePassword(@Body pass: Password, @Header("Authorization") bearerToken: String): Call<Void>
}