package li.vin.my.apikit.api

import li.vin.my.apikit.models.TermsAgreements
import li.vin.my.apikit.models.TermsItem
import li.vin.my.apikit.models.TermsList
import li.vin.my.apikit.models.TermsPostAgreements
import retrofit2.Call
import retrofit2.http.*

/**
 * 12/9/18.
 */
interface TermsAPI {

    @GET("/api/v1/terms")
    fun getTerms(): Call<TermsList>

    @GET("/api/v1/terms/{termId}")
    fun getTerm(@Path("termId") termId: String): Call<TermsItem>

    @GET("/api/v1/terms/{termId}")
    fun getTermHtml(@Header("Accept") header: String, @Path("termId") termId: String): Call<String>

    @GET("/api/v1/agreements")
    fun getAgreement(
        @Query("termId") termId: String,
        @Header("Authorization") sessionCookie: String
    ): Call<TermsAgreements>

    @POST("/api/v1/agreements")
    fun agreeToTerms(
        @Body agreement: TermsPostAgreements,
        @Query("termId") termId: String, @Header("Authorization") sessionCookie: String
    ): Call<Void>
}