package li.vin.my.apikit.api

import li.vin.my.apikit.models.Events
import retrofit2.Call
import retrofit2.http.GET
import retrofit2.http.Header
import retrofit2.http.Path
import retrofit2.http.Query

interface EventsAPI {

    @GET("/api/v1/devices/{deviceId}/events")
    fun getDeviceEvents(@Path("deviceId") deviceId: String,
                        @Query("since") since: Long,
                        @Query("limit") limit: Long,
                        @Query("until") until: Long,
                        @Header("Authorization") sessionCookie: String): Call<Events>

    @GET("/api/v1/vehicles/{vehicleId}/events")
    fun getVehicleEvents(@Path("vehicleId") vehicleId: String,
                         @Query("since") since: Long,
                         @Query("limit") limit: Long,
                         @Query("until") until: Long,
                         @Header("Authorization") sessionCookie: String): Call<Events>

//    @GET("/api/v1/events/{eventId}")
//    fun getEvent(@Path("eventId") eventId: String,
//                 @Header("Authorization") sessionCookie: String): Call<SingleEvent>
}