package li.vin.my.apikit.models

import com.google.gson.annotations.SerializedName

/**
 * 1/18/19.
 */
data class Provider(@SerializedName("provider") val provider: ProviderData?)

data class ProviderData(
    @SerializedName("id") val id: String?,
    @SerializedName("carrierId") val carrierId: String?,
    @SerializedName("name") val name: String?,
    @SerializedName("settings") val settings: ProviderSettings?
)

data class ProviderSettings(
    @SerializedName("country") val country: String?,
    @SerializedName("features") val features: ProviderFeatures?,
    @SerializedName("images") val images: ProviderImages?
)

data class ProviderFeatures(
    @SerializedName("allowAppStore") val allowAppStore: Boolean?,
    @SerializedName("allowWifiUsage") val allowWifiUsage: Boolean?,
    @SerializedName("allowWifiPurchase") val allowWifiPurchase: Boolean?,
    @SerializedName("allowBasicServices") val allowBasicServices: Boolean?,
    @SerializedName("allowPremiumServices") val allowPremiumServices: Boolean?,
    @SerializedName("allowBilling") val allowBilling: Boolean?,
    @SerializedName("allowBingeOn") val allowBingeOn: Boolean?
)

data class ProviderImages(@SerializedName("carrierLogo") val carrierLogo: ProviderLogo?)

data class ProviderLogo(
    @SerializedName("sm") val sm: String?,
    @SerializedName("md") val md: String?,
    @SerializedName("lg") val lg: String?,
    @SerializedName("mobile") val mobile: String?
)