package li.vin.my.apikit.services

import li.vin.my.apikit.api.UserAPI
import li.vin.my.apikit.models.Password
import li.vin.my.apikit.models.UpdatePassword
import li.vin.my.apikit.network.BaseService
import li.vin.my.apikit.network.Endpoints

/**
 * 12/27/18.
 */
class UpdatePasswordService(private val newPassword: String, private val oldPassword: String) : BaseService<Void>() {

    override fun createCall() {
        val request = createService(UserAPI::class.java, Endpoints.getAuthBaseUrl())
        call = request.updatePassword(Password(UpdatePassword(newPassword, oldPassword)), getAuthToken())
    }
}